% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-coercion.R
\docType{methods}
\name{as}
\alias{as}
\alias{as,SoilProfileCollection-method}
\title{Coerce SoilProfileCollection with \code{as()}}
\value{
list

data.frame

tbl_df

data.table

SpatialPointsDataFrame

SpatialPoints
}
\description{
SoilProfileCollections can be coerced to other R object types using \code{as(spc, 'type')}.

Possible endpoints include: \code{list}, \code{data.frame}, \code{SpatialPointsDataFrame} and \code{SpatialPoints}.
}
\examples{
# load example data stored as SoilProfileCollection
data(sp5)

# sp5
str(sp5)

# list output
str(as(sp5, 'list'))

# data.frame output
str(as(sp5, 'data.frame'))

# Spatial Objects
# make some random coordinate data for each profile
sp5$x <- sp5$y <- rnorm(length(sp5))
coordinates(sp5) <- ~ x + y

# SpatialPointsDataFrame output
str(as(sp5, 'SpatialPointsDataFrame'))

# SpatialPoints output
str(as(sp5, 'SpatialPoints'))
}
