% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_tooltip}
\alias{ax_tooltip}
\title{Tooltip options}
\usage{
ax_tooltip(ax, enabled = NULL, shared = NULL, followCursor = NULL,
  intersect = NULL, inverseOrder = NULL, custom = NULL,
  fillSeriesColor = NULL, onDatasetHover = NULL, theme = NULL,
  x = NULL, y = NULL, z = NULL, marker = NULL, items = NULL,
  fixed = NULL, ...)
}
\arguments{
\item{ax}{A \code{apexcharts} \code{htmlwidget} object.}

\item{enabled}{Logical. Show tooltip when user hovers over chart area.}

\item{shared}{Logical. When having multiple series, show a shared tooltip.}

\item{followCursor}{Logical. Follow user’s cursor position instead of putting tooltip on actual data points.}

\item{intersect}{Logical. Show tooltip only when user hovers exactly over datapoint.}

\item{inverseOrder}{Logical. In multiple series, when having shared tooltip, inverse the order of series (for better comparison in stacked charts).}

\item{custom}{JS function. Draw a custom html tooltip instead of the default one based on the values provided in the function arguments.}

\item{fillSeriesColor}{Logical. When enabled, fill the tooltip background with the corresponding series color.}

\item{onDatasetHover}{A list of parameters.}

\item{theme}{A list of parameters.}

\item{x}{A list of parameters.}

\item{y}{A list of parameters.}

\item{z}{A list of parameters.}

\item{marker}{A list of parameters.}

\item{items}{A list of parameters.}

\item{fixed}{A list of parameters.}

\item{...}{Additional parameters.}
}
\value{
A \code{apexcharts} \code{htmlwidget} object.
}
\description{
Tooltip options
}
\note{
See \url{https://apexcharts.com/docs/options/tooltip/}
}
\examples{
library(dplyr)
data("mpg", package = "ggplot2")

# Hide tooltip
apex(
  data = count(mpg, manufacturer, year),
  mapping = aes(x = manufacturer, y = n, fill = year)
) \%>\% 
  ax_tooltip(enabled = FALSE)

# Share between series
apex(
  data = count(mpg, manufacturer, year),
  mapping = aes(x = manufacturer, y = n, fill = year)
) \%>\% 
  ax_tooltip(shared = TRUE)

# Fixed tooltip
data("economics", package = "ggplot2")
apex(
  data = economics,
  mapping = aes(x = date, y = psavert),
  type = "line"
) \%>\% 
  ax_tooltip(
    fixed = list(enabled = TRUE, position = "topLeft")
  )
}
