% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/circplot.R
\name{circplot}
\alias{circplot}
\title{Circular network plot}
\usage{
circplot(Y, U = NULL, V = NULL, row.names = rownames(Y),
  col.names = colnames(Y), plotnames = TRUE, vscale = 0.8,
  pscale = 1.75, lcol = "gray", rcol = "brown", ccol = "blue",
  pch = 16, lty = 3, jitter = 0.1 * (nrow(Y)/(1 + nrow(Y))), bty = "n",
  add = FALSE)
}
\arguments{
\item{Y}{(matrix) m by n relational matrix.}

\item{U}{(matrix) m by 2 matrix of row factors of Y.}

\item{V}{(matrix) n by 2 matrix of column factors of Y.}

\item{row.names}{(character vector) names of the row objects.}

\item{col.names}{(character vector) names of the columns objects.}

\item{plotnames}{(logical) plot row and column names.}

\item{vscale}{(scalar) scaling factor for V coordinates.}

\item{pscale}{(scalar) scaling factor for plotting characters.}

\item{lcol}{(scalar or vector) line color(s) for the nonzero elements of Y.}

\item{rcol}{(scalar or vector) node color(s) for the rows.}

\item{ccol}{(scalar or vector) node color(s) for the columns.}

\item{pch}{(integer) plotting character.}

\item{lty}{(integer) line type.}

\item{jitter}{(scalar) a number to control jittering of nodes.}

\item{bty}{(character) bounding box type.}

\item{add}{(logical) add to existing plot}
}
\description{
Produce a circular network plot.
}
\details{
This function creates a circle plot of a relational matrix or social network.
If not supplied via \code{U} and \code{V}, two-dimensional row factors and
column factors are computed from the SVD of \code{Y}, scaled versions of
which are used to plot positions on the outside edge (\code{U}) and inside
edge (\code{V}) of the circle plot. The magnitudes of the plotting characters
are determined by the magnitudes of the rows of \code{U} and \code{V}.
Segments are drawn between each row object \code{i} and column object
\code{j} for which \code{Y[i,j]!=0}.
}
\examples{
data(IR90s)
circplot(IR90s$dyadvars[,,1])
}
\author{
Peter Hoff
}

