% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{run_performance}
\alias{run_performance}
\title{Apply calculate performance metrics for model evaluation}
\usage{
run_performance(model)
}
\arguments{
\item{model}{A model_df. results of predicted model that created by run_predict().}
}
\value{
model_df. results of predicted model.
model_df is composed of tbl_df and contains the following variables.:
\itemize{
\item step : character. The current stage in the model fit process. The result of calling run_performance() is returned as "3.Performanced".
\item model_id : character. Type of fit model.
\item target : character. Name of target variable.
\item positive : character. Level of positive class of binary classification.
\item fitted_model : list. Fitted model object.
\item predicted : list. Predicted value by individual model. Each value has a predict_class class object.
\item performance : list. Calculate metrics by individual model. Each value has a numeric vector.
}
The performance metrics calculated are as follows.:
\itemize{
\item ZeroOneLoss : Normalized Zero-One Loss(Classification Error Loss).
\item Accuracy : Accuracy.
\item Precision : Precision.
\item Recall : Recall.
\item Sensitivity : Sensitivity.
\item Specificity : Specificity.
\item F1_Score : F1 Score.
\item Fbeta_Score : F-Beta Score.
\item LogLoss : Log loss / Cross-Entropy Loss.
\item AUC : Area Under the Receiver Operating Characteristic Curve (ROC AUC).
\item Gini : Gini Coefficient.
\item PRAUC : Area Under the Precision-Recall Curve (PR AUC).
\item LiftAUC : Area Under the Lift Chart.
\item GainAUC : Area Under the Gain Chart.
\item KS_Stat : Kolmogorov-Smirnov Statistic.
}
}
\description{
Apply calculate performance metrics for binary classification model evaluation.
}
\examples{
library(dplyr)

# Divide the train data set and the test data set.
sb <- rpart::kyphosis \%>\%
  split_by(Kyphosis)

# Extract the train data set from original data set.
train <- sb \%>\%
  extract_set(set = "train")

# Extract the test data set from original data set.
test <- sb \%>\%
  extract_set(set = "test")

# Sampling for unbalanced data set using SMOTE(synthetic minority over-sampling technique).
train <- sb \%>\%
  sampling_target(seed = 1234L, method = "ubSMOTE")

# Cleaning the set.
train <- train \%>\%
  cleanse

# Run the model fitting.
result <- run_models(.data = train, target = "Kyphosis", positive = "present")
result

# Predict the model.
pred <- run_predict(result, test)
pred

# Calculate performace metrics.
perf <- run_performance(pred)
perf
perf$performance

# Convert to matrix for compare performace.
sapply(perf$performance, "c")

}
