% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aldvmm.ll.R
\name{aldvmm.ll}
\alias{aldvmm.ll}
\title{Calculating the Negative Log-Likelihood of the Adjusted Limited Dependent
Variable Mixture Model}
\usage{
aldvmm.ll(par, X, y, psi, ncmp, dist, lcoef, lcpar, lcmp, optim.method)
}
\arguments{
\item{par}{a named numeric vector of parameter values.}

\item{X}{a list of design matrices returned by
\ifelse{html}{\code{\link[aldvmm]{aldvmm.mm}}}{\code{aldvmm.mm()}}.
\code{'X'} is of length 2 and includes a design matrix for the model of
component distributions and a design matrix for the model of probabilities
of group membership.}

\item{y}{a numeric vector of observed outcomes from complete observations in
\code{'data'} supplied to
\ifelse{html}{\code{\link[aldvmm]{aldvmm}}}{\code{aldvmm()}}.}

\item{psi}{a numeric vector of minimum and maximum possible utility values
smaller than or equal to 1 (e.g. \code{c(-0.594, 0.883)}). The potential
gap between the maximum value and 1 represents an area with zero density
in the value set from which utilities were obtained. The order of the
minimum and maximum limits in \code{'psi'} does not matter.}

\item{ncmp}{a numeric value of the number of components that are mixed. The
default value is 2. A value of 1 represents a tobit model with a gap
between 1 and the maximum value in \code{'psi'}.}

\item{dist}{an optional character value of the distribution used in the
finite mixture. In this release, only the normal distribution is
available, and the default value is set to \code{"normal"}.}

\item{lcoef}{a character vector of length 2 with labels of objects including
regression coefficients of component distributions (default \code{"beta"})
and coefficients of probabilities of component membership (default
\code{"delta"}).}

\item{lcpar}{a character vector with the labels of objects including
constant parameters of component distributions (e.g. the standard
deviation of the normal distribution). The length of \code{'lcpar'}
depends on the distribution supplied to \code{'dist'}.}

\item{lcmp}{a character value representing a stub (default \code{"Comp"})
for labeling objects including regression coefficients in different
components (e.g. "Comp1", "Comp2", ...). This label is also used in
summary tables returned by
\ifelse{html}{\code{\link[aldvmm]{summary.aldvmm}}}{\code{summary.aldvmm()}}.}

\item{optim.method}{an optional character value of one of the following
\ifelse{html}{\code{\link[optimr]{optimr}}}{\code{optimr::optimr()}}
methods: \code{"Nelder-Mead"}, \code{"BFGS"}, \code{"CG"},
\code{"L-BFGS-B"}, \code{"nlminb"}, \code{"Rcgmin"}, \code{"Rvmmin"} and
\code{"hjn"}. The default method is \code{"BFGS"}. The method
\code{"L-BFGS-B"} is used when lower and/or upper constraints are set
using \code{'init.lo'} and \code{'init.hi'}. The method \code{"nlm"}
cannot be used in the \code{'aldvmm'} package.}
}
\value{
a scalar of the negative log-likelihood of the data at parameter
  values in \code{'par'}.
}
\description{
\ifelse{html}{\code{\link[aldvmm]{aldvmm.ll}}}{\code{aldvmm.ll()}}
calculates the negative log-likelihood of \code{'data'} supplied to
\ifelse{html}{\code{\link[aldvmm]{aldvmm}}}{\code{aldvmm()}} at the
parameter values in \code{'par'}.
}
\details{
\ifelse{html}{\code{\link[aldvmm]{aldvmm.ll}}}{\code{aldvmm.ll()}}
  calculates the negative log-likelihood of the adjusted limited dependent
  variable mixture model using the likelihood function published in
  Hernandez Alava and Wailoo (2015). Constant distribution parameters that
  need to be non-negative (i.e. the standard deviations of normal
  distributions) enter the likelihood function as log-transformed values.

  As the "L-BFGS-B" and "Rcgmin" methods in
  \ifelse{html}{\code{\link[optimr]{optimr}}}{\code{optimr::optimr()}} fail
  if they encounter infinite values, the log-likelihood function takes the
  value -1e+20 if it is infinite during these algorithms.

  The names of the parameter vector supplied to \code{'par'} must be
  generated using \ifelse{html}{\code{\link[aldvmm]{aldvmm.getnames}}}{
  \code{aldvmm.getnames()}} because they will be inherited by return values
  of other functions in the package \code{'aldvmm'}. The names will also be
  used in the extraction of parameters from parameter vectors into nested
  lists using
  \ifelse{html}{\code{\link[aldvmm]{aldvmm.getpar}}}{\code{aldvmm.getpar()}}.
}
\references{
Alava, M. H. and Wailoo, A. (2015) Fitting adjusted limited
  dependent variable mixture models to EQ-5D. \emph{The Stata Journal},
  \bold{15(3)}, 737--750. \doi{10.1177/1536867X1501500307} \cr
}
