% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aldvmm.check.R
\name{aldvmm.check}
\alias{aldvmm.check}
\title{Checking the Validity of Objects Supplied to
\ifelse{html}{\code{\link[aldvmm]{aldvmm}}}{\code{aldvmm()}}}
\usage{
aldvmm.check(
  formula,
  data,
  psi,
  ncmp,
  dist,
  optim.method,
  optim.control,
  optim.grad,
  init.method,
  init.est,
  init.lo,
  init.hi,
  se.fit,
  model,
  level,
  na.action,
  lcoef,
  lcpar,
  lcmp
)
}
\arguments{
\item{formula}{an object of class \code{"formula"} with a symbolic
description of the model to be fitted. The model formula takes the form
\code{y ~ x1 + x2 | x1 + x4}, where the \code{|} delimiter separates the
model for expected values of normal distributions (left) and the
multinomial logit model of probabilities of component membership (right).}

\item{data}{a data frame, list or environment (or object coercible to a data
frame by \ifelse{html}{\code{\link[base]{as.data.frame}}}{\code{base::as.data.frame()}}) including data on outcomes and explanatory
variables in \code{'formula'}.}

\item{psi}{a numeric vector of minimum and maximum possible utility values
smaller than or equal to 1 (e.g. \code{c(-0.594, 0.883)}). The potential
gap between the maximum value and 1 represents an area with zero density
in the value set from which utilities were obtained. The order of the
minimum and maximum limits in \code{'psi'} does not matter.}

\item{ncmp}{a numeric value of the number of components that are mixed. The
default value is 2. A value of 1 represents a tobit model with a gap
between 1 and the maximum value in \code{'psi'}.}

\item{dist}{an optional character value of the distribution used in the
finite mixture. In this release, only the normal distribution is
available, and the default value is set to \code{"normal"}.}

\item{optim.method}{an optional character value of one of the following
\ifelse{html}{\code{\link[optimr]{optimr}}}{\code{optimr::optimr()}}
methods: \code{"Nelder-Mead"}, \code{"BFGS"}, \code{"CG"},
\code{"L-BFGS-B"}, \code{"nlminb"}, \code{"Rcgmin"}, \code{"Rvmmin"} and
\code{"hjn"}. The default method is \code{"BFGS"}. The method
\code{"L-BFGS-B"} is used when lower and/or upper constraints are set
using \code{'init.lo'} and \code{'init.hi'}. The method \code{"nlm"}
cannot be used in the \code{'aldvmm'} package.}

\item{optim.control}{an optional list of
\ifelse{html}{\code{\link[optimr]{optimr}}}{\code{optimr::optimr()}}
control parameters.}

\item{optim.grad}{an optional logical value indicating if a numerical
gradient should be used in
\ifelse{html}{\code{\link[optimr]{optimr}}}{\code{optimr::optimr()}}
methods that can use this information. The default value is \code{TRUE}.
If \code{'optim.grad'} is set to \code{FALSE}, a finite difference
approximation is used.}

\item{init.method}{an optional character value indicating the method for
obtaining initial values. The following values are available:
\code{"zero"}, \code{"random"}, \code{"constant"} and \code{"sann"}. The
default value is \code{"zero"}.}

\item{init.est}{an optional numeric vector of user-defined initial values.
User-defined initial values override the \code{'init.method'} argument.
Initial values have to follow the same order as parameter estimates in the
return value \code{'par'}.}

\item{init.lo}{an optional numeric vector of user-defined lower limits for
constrained optimization. When \code{'init.lo'} is not \code{NULL}, the
optimization method \code{"L-BFGS-B"} is used. Lower limits of parameters
have to follow the same order as parameter estimates in the return value
\code{'par'}.}

\item{init.hi}{an optional numeric vector of user-defined upper limits for
constrained optimization. When \code{'init.hi'} is not \code{NULL}, the
optimization method \code{"L-BFGS-B"} is used. Upper limits of parameters
have to follow the same order as parameter estimates in the return value
\code{'par'}.}

\item{se.fit}{an optional logical value indicating whether standard errors
of fitted values are calculated. The default value is \code{FALSE}.}

\item{model}{an optional logical value indicating whether the estimation 
data frame is returned in the output object. The default value is \code{TRUE}.}

\item{level}{a numeric value of the significance level for confidence bands
of fitted values. The default value is 0.95.}

\item{na.action}{a character value indicating the argument passed to 
argument \code{'na.action'} of the function 
\ifelse{html}{\code{\link[stats]{model.frame}}}{\code{stats::model.frame()}} 
in the preparation of the model matrix. The default value is 
\code{"na.omit"}.}

\item{lcoef}{a character vector of length 2 with labels of objects including
regression coefficients of component distributions (default \code{"beta"})
and coefficients of probabilities of component membership (default
\code{"delta"}).}

\item{lcpar}{a character vector with the labels of objects including
constant parameters of component distributions (e.g. the standard
deviation of the normal distribution). The length of \code{'lcpar'}
depends on the distribution supplied to \code{'dist'}.}

\item{lcmp}{a character value representing a stub (default \code{"Comp"})
for labeling objects including regression coefficients in different
components (e.g. "Comp1", "Comp2", ...). This label is also used in
summary tables returned by
\ifelse{html}{\code{\link[aldvmm]{summary.aldvmm}}}{\code{summary.aldvmm()}}.}
}
\value{
\code{aldvmm.check} returns warnings or stops the execution of
  \ifelse{html}{\code{\link[aldvmm]{aldvmm}}}{\code{aldvmm()}} if validity
  checks fail.
}
\description{
\ifelse{html}{\code{\link[aldvmm]{aldvmm.check}}}{\code{aldvmm.check()}}
runs validity checks of objects supplied to
\ifelse{html}{\code{\link[aldvmm]{aldvmm}}}{\code{aldvmm()}}.
}
\details{
\ifelse{html}{\code{\link[aldvmm]{aldvmm.check}}}{\code{aldvmm.check()}}
checks the validity of arguments of
\ifelse{html}{\code{\link[aldvmm]{aldvmm}}}{\code{aldvmm()}}.
}
