% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aldvmm.R
\docType{package}
\name{aldvmm-package}
\alias{aldvmm-package}
\title{aldvmm: Adjusted Limited Dependent Variable Mixture Models}
\description{
The goal of the package 'aldvmm' is to fit adjusted limited dependent
variable mixture models of health state utilities. Adjusted limited
dependent variable mixture models are finite mixtures of normal
distributions with an accumulation of density mass at the limits, and a gap
between 100\% quality of life and the next smaller utility value. The
package 'aldvmm' uses the likelihood and expected value functions proposed
by Hernandez Alava and Wailoo (2015) <doi: 10.1177/1536867X1501500307> using
normal component distributions and a multinomial logit model of
probabilities of component membership.
}
\examples{
data(utility)

 fit <- aldvmm(eq5d ~ age + female | 1,
               data = utility,
               psi = c(0.883, -0.594),
               ncmp = 2)

 summary(fit)

 yhat <- predict(fit,
                 newdata = utility)

}
