% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axialAnalysis.R
\name{axialAnalysisLocal}
\alias{axialAnalysisLocal}
\title{Axial analysis - local metrics}
\usage{
axialAnalysisLocal(shapeGraph, verbose = FALSE)
}
\arguments{
\item{shapeGraph}{An Axial ShapeGraph}

\item{verbose}{Optional. Show more information of the process.}
}
\value{
Returns a list with:
\itemize{
  \item{completed: Whether the analysis completed}
  \item{newAttributes: The new attributes that were created during the
  process}
}
}
\description{
Runs axial analysis to get the local metrics Control and Controllability
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "barnsbury",
    "barnsbury_small_axial_original.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeGraph <- as(sfMap, "AxialShapeGraph")
axialAnalysisLocal(shapeGraph)
}
