% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_measures.R
\name{get_coder_metrics}
\alias{get_coder_metrics}
\title{Calculate reliability measures based on content analysis}
\usage{
get_coder_metrics(
  true_values = NULL,
  predicted_values = NULL,
  return_names_only = FALSE
)
}
\arguments{
\item{true_values}{\code{factor} containing the true labels/categories.}

\item{predicted_values}{\code{factor} containing the predicted labels/categories.}

\item{return_names_only}{\code{bool} If \code{TRUE} returns only the names of the resulting vector. Use \code{FALSE} to request
computation of the values.}
}
\value{
If \code{return_names_only = FALSE} returns a \code{vector} with the following reliability measures:
\itemize{
\item \strong{iota_index}: Iota Index from the Iota Reliability Concept Version 2.
\item \strong{min_iota2}: Minimal Iota from Iota Reliability Concept Version 2.
\item \strong{avg_iota2}: Average Iota from Iota Reliability Concept Version 2.
\item \strong{max_iota2}: Maximum Iota from Iota Reliability Concept Version 2.
\item \strong{min_alpha}: Minmal Alpha Reliability from Iota Reliability Concept Version 2.
\item \strong{avg_alpha}: Average Alpha Reliability from Iota Reliability Concept Version 2.
\item \strong{max_alpha}: Maximum Alpha Reliability from Iota Reliability Concept Version 2.
\item \strong{static_iota_index}: Static Iota Index from Iota Reliability Concept Version 2.
\item \strong{dynamic_iota_index}: Dynamic Iota Index Iota Reliability Concept Version 2.
\item \strong{kalpha_nominal}: Krippendorff's Alpha for nominal variables.
\item \strong{kalpha_ordinal}: Krippendorff's Alpha for ordinal variables.
\item \strong{kendall}: Kendall's coefficient of concordance W with correction for ties.
\item \strong{c_kappa_unweighted}: Cohen's Kappa unweighted.
\item \strong{c_kappa_linear}: Weighted Cohen's Kappa with linear increasing weights.
\item \strong{c_kappa_squared}: Weighted Cohen's Kappa with quadratic increasing weights.
\item \strong{kappa_fleiss}: Fleiss' Kappa for multiple raters without exact estimation.
\item \strong{percentage_agreement}: Percentage Agreement.
\item \strong{balanced_accuracy}: Average accuracy within each class.
\item \strong{gwet_ac1_nominal}: Gwet's Agreement Coefficient 1 (AC1) for nominal data which is unweighted.
\item \strong{gwet_ac2_linear}: Gwet's Agreement Coefficient 2 (AC2) for ordinal data with linear weights.
\item \strong{gwet_ac2_quadratic}: Gwet's Agreement Coefficient 2 (AC2) for ordinal data with quadratic weights.
}

If \code{return_names_only = TRUE} returns only the names of the vector elements.
}
\description{
This function calculates different reliability measures which are based on the empirical research method
of content analysis.
}
\seealso{
Other performance measures: 
\code{\link{calc_standard_classification_measures}()},
\code{\link{cohens_kappa}()},
\code{\link{fleiss_kappa}()},
\code{\link{gwet_ac}()},
\code{\link{kendalls_w}()},
\code{\link{kripp_alpha}()}
}
\concept{performance measures}
