% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{aelab_palettes}
\alias{aelab_palettes}
\title{aelab_palettes}
\usage{
aelab_palettes(name, n, type = c("discrete", "continuous"))
}
\arguments{
\item{name}{Name of the palette (string).}

\item{n}{Number of colours to return. Defaults to the full palette length.}

\item{type}{\code{"discrete"} (default) or \code{"continuous"}. For
\code{"continuous"}, colours are interpolated to length \code{n}.}
}
\value{
A character vector of hex colour codes with class \code{"palette"}.
}
\description{
Retrieve a named aelab colour palette as a character vector.
}
\details{
Available palette names: \code{"rainbow"}, \code{"two"},
  \code{"control"}, \code{"control2"}, \code{"control3"},
  \code{"period"}, \code{"ghg"}.
}
\examples{
aelab_palettes("rainbow", 5)
aelab_palettes("ghg", type = "continuous", n = 20)
}
