% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_filter_cond}
\alias{assert_filter_cond}
\title{Is an Argument a Filter Condition?}
\usage{
assert_filter_cond(arg, optional = FALSE)
}
\arguments{
\item{arg}{Quosure - filtering condition.}

\item{optional}{Logical - is the argument optional? Defaults to \code{FALSE}.}
}
\value{
Performs necessary checks and returns \code{arg} if all pass.
Otherwise throws an informative error.
}
\description{
Is an Argument a Filter Condition?
}
\details{
Check if \code{arg} is a suitable filtering condition to be used in
functions like \code{subset} or \code{dplyr::filter}.
}
\examples{
library(admiral.test)
data(dm)

# typical usage in a function as a parameter check
example_fun <- function(dat, x) {
  x <- assert_filter_cond(rlang::enquo(x))
  dplyr::filter(dat, !!x)
}

example_fun(dm, AGE == 64)

try(example_fun(dm, USUBJID))
}
\author{
Ondrej Slama
}
\keyword{assertion}
