% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_wbc_abs.R
\name{derive_param_wbc_abs}
\alias{derive_param_wbc_abs}
\title{Add a parameter for lab differentials converted to absolute values}
\usage{
derive_param_wbc_abs(
  dataset,
  by_vars,
  set_values_to,
  get_unit_expr,
  wbc_unit = "10^9/L",
  wbc_code = "WBC",
  diff_code,
  diff_type = "fraction"
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument, \code{PARAMCD}, and \code{AVAL}
are expected to be present.

The variable specified by \code{by_vars} and \code{PARAMCD} must be a unique key of
the input dataset, and to the parameters specified by \code{wbc_code} and \code{diff_code}.}

\item{by_vars}{Grouping variables

Permitted Values: list of variables}

\item{set_values_to}{Variables to set

A named list returned by \code{exprs()} defining the variables to be set for the
new parameter, e.g. \code{exprs(PARAMCD = "LYMPH", PARAM = "Lymphocytes Abs (10^9/L)")} is
expected.}

\item{get_unit_expr}{An expression providing the unit of the parameter

The result is used to check the units of the input parameters.

Permitted Values: a variable containing unit from the input dataset, or a function call,
for example, \code{get_unit_expr = extract_unit(PARAM)}.}

\item{wbc_unit}{A string containing the required unit of the WBC parameter

Default: \code{"10^9/L"}}

\item{wbc_code}{White Blood Cell (WBC) parameter

The observations where \code{PARAMCD} equals the specified value are considered
as the WBC absolute results to use for converting the differentials.

Default: \code{"WBC"}

Permitted Values: character value}

\item{diff_code}{white blood differential parameter

The observations where \code{PARAMCD} equals the specified value are considered
as the white blood differential lab results in fraction or percentage value to be converted
into absolute value.}

\item{diff_type}{A string specifying the type of differential

Permitted Values: \code{"percent"}, \code{"fraction"}
Default: \code{fraction}}
}
\value{
The input dataset with the new parameter added
}
\description{
Add a parameter by converting lab differentials from fraction or percentage to absolute values
}
\details{
If \code{diff_type} is \code{"percent"}, the analysis value of the new parameter is derived as
\deqn{\frac{White Blood Cell Count  * Percentage Value}{100}}

If \code{diff_type} is \code{"fraction"}, the analysis value of the new parameter is derived as
\deqn{White Blood Cell Count  * Fraction Value}

New records are created for each group of records (grouped by \code{by_vars}) if 1) the white blood
cell component in absolute value is not already available from the input dataset, and 2) the
white blood cell absolute value (identified by \code{wbc_code}) and the white blood cell differential
(identified by \code{diff_code}) are both present.
}
\examples{
library(tibble)

test_lb <- tribble(
  ~USUBJID, ~PARAMCD, ~AVAL, ~PARAM, ~VISIT,
  "P01", "WBC", 33, "Leukocyte Count (10^9/L)", "CYCLE 1 DAY 1",
  "P01", "WBC", 38, "Leukocyte Count (10^9/L)", "CYCLE 2 DAY 1",
  "P01", "LYMLE", 0.90, "Lymphocytes (fraction of 1)", "CYCLE 1 DAY 1",
  "P01", "LYMLE", 0.70, "Lymphocytes (fraction of 1)", "CYCLE 2 DAY 1",
  "P01", "ALB", 36, "Albumin (g/dL)", "CYCLE 2 DAY 1",
  "P02", "WBC", 33, "Leukocyte Count (10^9/L)", "CYCLE 1 DAY 1",
  "P02", "LYMPH", 29, "Lymphocytes Abs (10^9/L)", "CYCLE 1 DAY 1",
  "P02", "LYMLE", 0.87, "Lymphocytes (fraction of 1)", "CYCLE 1 DAY 1",
  "P03", "LYMLE", 0.89, "Lymphocytes (fraction of 1)", "CYCLE 1 DAY 1"
)

derive_param_wbc_abs(
  dataset = test_lb,
  by_vars = exprs(USUBJID, VISIT),
  set_values_to = exprs(
    PARAMCD = "LYMPH",
    PARAM = "Lymphocytes Abs (10^9/L)",
    DTYPE = "CALCULATION"
  ),
  get_unit_expr = extract_unit(PARAM),
  wbc_code = "WBC",
  diff_code = "LYMLE",
  diff_type = "fraction"
)
}
\seealso{
BDS-Findings Functions for adding Parameters/Records: 
\code{\link{default_qtc_paramcd}()},
\code{\link{derive_expected_records}()},
\code{\link{derive_extreme_event}()},
\code{\link{derive_extreme_records}()},
\code{\link{derive_locf_records}()},
\code{\link{derive_param_bmi}()},
\code{\link{derive_param_bsa}()},
\code{\link{derive_param_computed}()},
\code{\link{derive_param_doseint}()},
\code{\link{derive_param_exist_flag}()},
\code{\link{derive_param_exposure}()},
\code{\link{derive_param_extreme_record}()},
\code{\link{derive_param_framingham}()},
\code{\link{derive_param_map}()},
\code{\link{derive_param_qtc}()},
\code{\link{derive_param_rr}()},
\code{\link{derive_summary_records}()}
}
\concept{der_prm_bds_findings}
\keyword{der_prm_bds_findings}
