% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_extreme_record.R
\name{derive_param_extreme_record}
\alias{derive_param_extreme_record}
\title{Adds a Parameter Based on First or Last Record from Multiple Sources}
\usage{
derive_param_extreme_record(
  dataset = NULL,
  sources,
  source_datasets,
  by_vars = NULL,
  order,
  mode,
  set_values_to
)
}
\arguments{
\item{dataset}{Input dataset}

\item{sources}{Sources

A list of \code{records_source()} objects is expected.}

\item{source_datasets}{Source datasets

A named list of datasets is expected. The \code{dataset_name} field of
\code{records_source()} refers to the dataset provided in the list. The variables
specified by the \code{order} and the \code{by_vars} arguments are expected after applying \code{new_vars}.}

\item{by_vars}{By variables

If the argument is specified, for each by group the observations are
selected separately.}

\item{order}{Sort order

If the argument is set to a non-null value, for each by group the first or
last observation from the source datasets is selected with respect to
the specified order. Variables created via \code{new_vars} e.g., imputed date variables,
can be specified as well (see examples below).

Please note that \code{NA} is considered as the last value. I.e., if a order
variable is \code{NA} and \code{mode = "last"}, this observation is chosen while for
\code{mode = "first"} the observation is chosen only if there are no
observations where the variable is not \code{NA}.

\emph{Permitted Values:} list of expressions created by \code{exprs()}, e.g.,
\code{exprs(ADT, desc(AVAL))}}

\item{mode}{Selection mode (first or last)

If \code{"first"} is specified, for each by group the first observation with
respect to \code{order} is included in the output dataset. If \code{"last"} is
specified, the last observation is included in the output dataset.

Permitted Values:  \code{"first"}, \code{"last"}}

\item{set_values_to}{Variables to be set

The specified variables are set to the specified values for the new
observations.

A list of variable name-value pairs is expected.
\itemize{
\item LHS refers to a variable.
\item RHS refers to the values to set to the variable. This can be a string, a
symbol, a numeric value or \code{NA}, e.g., \code{exprs(PARAMCD = "PD", PARAM =   "First Progressive Disease")}.
}}
}
\value{
The input dataset with the first or last observation of each by group
added as new observations.
}
\description{
Generates parameter based on the first or last observation from multiple
source datasets, based on user-defined filter, order and by group criteria.
All variables of the selected observation are kept.
}
\details{
The following steps are performed to create the output dataset:

\enumerate{
\item For each source dataset the observations as specified by
the \code{filter} element are selected.

\item Variables specified by \code{new_vars} are created for each source dataset.

\item The first or last observation (with respect to the
\code{order} variable) for each by group (specified by \code{by_vars}) from multiple sources
is selected and added to the input dataset. }
}
\examples{
aevent_samp <- tibble::tribble(
  ~USUBJID, ~PARAMCD,                       ~PARAM,     ~RSSTDTC,
  "1",          "PD",  "First Progressive Disease", "2022-04-01",
  "2",          "PD",  "First Progressive Disease", "2021-04-01",
  "3",          "PD",  "First Progressive Disease", "2023-04-01"
)

cm <- tibble::tribble(
  ~STUDYID, ~USUBJID, ~CMDECOD,     ~CMSTDTC,
  "1001",        "1",    "ACT", "2021-12-25"
)

pr <- tibble::tribble(
  ~STUDYID, ~USUBJID, ~PRDECOD,     ~PRSTDTC,
  "1001",        "1",    "ACS", "2021-12-27",
  "1001",        "2",    "ACS", "2020-12-25",
  "1001",        "3",    "ACS", "2022-12-25",
)
derive_param_extreme_record(
  dataset = aevent_samp,
  sources = list(
    records_source(
      dataset_name = "cm",
      filter = CMDECOD == "ACT",
      new_vars = exprs(
        ADT = convert_dtc_to_dt(CMSTDTC),
        AVALC = CMDECOD
      )
    ),
    records_source(
      dataset_name = "pr",
      filter = PRDECOD == "ACS",
      new_vars = exprs(
        ADT = convert_dtc_to_dt(PRSTDTC),
        AVALC = PRDECOD
      )
    )
  ),
  source_datasets = list(cm = cm, pr = pr),
  by_vars = exprs(USUBJID),
  order = exprs(ADT),
  mode = "first",
  set_values_to = exprs(
    PARAMCD = "FIRSTACT",
    PARAM = "First Anti-Cancer Therapy"
  )
)
}
\seealso{
BDS-Findings Functions for adding Parameters/Records: 
\code{\link{default_qtc_paramcd}()},
\code{\link{derive_expected_records}()},
\code{\link{derive_extreme_event}()},
\code{\link{derive_extreme_records}()},
\code{\link{derive_locf_records}()},
\code{\link{derive_param_bmi}()},
\code{\link{derive_param_bsa}()},
\code{\link{derive_param_computed}()},
\code{\link{derive_param_doseint}()},
\code{\link{derive_param_exist_flag}()},
\code{\link{derive_param_exposure}()},
\code{\link{derive_param_framingham}()},
\code{\link{derive_param_map}()},
\code{\link{derive_param_qtc}()},
\code{\link{derive_param_rr}()},
\code{\link{derive_param_wbc_abs}()},
\code{\link{derive_summary_records}()}
}
\concept{der_prm_bds_findings}
\keyword{der_prm_bds_findings}
