#' @title WikidataQueryServiceR: An R Wrapper For Wikidata Query Service API
#' @description This is an R wrapper for the
#'   [Wikidata Query Service](https://www.wikidata.org/wiki/Wikidata:SPARQL_query_service)
#'   (WDQS) which provides a way for tools to query Wikidata via
#'   [SPARQL](https://en.wikipedia.org/wiki/SPARQL).
#' @details [Wikidata Query Service](https://www.mediawiki.org/wiki/Wikidata_query_service)
#'   is maintained by [Wikimedia Foundation](https://wikimediafoundation.org/).
#' @references
#' - [A beginner-friendly course for SPARQL](https://www.wikidata.org/wiki/Wikidata:A_beginner-friendly_course_for_SPARQL)
#' - Building a SPARQL query: [Museums on Instagram](https://www.wikidata.org/wiki/Help:SPARQL/Building_a_query/Museums_on_Instagram)
#' - [SPARQL Query Examples](https://www.wikidata.org/wiki/Wikidata:SPARQL_query_service/queries/examples) for WDQS
#' - [Using SPARQL to access Linked Open Data](http://programminghistorian.org/lessons/graph-databases-and-SPARQL)
#'   by Matthew Lincoln
#' - Interesting or illustrative [SPARQL queries](https://www.wikidata.org/wiki/Wikidata:SPARQL_query_service/queries)
#'   for Wikidata
#' - Wikidata [2016 SPARQL Workshop](https://www.wikidata.org/wiki/Wikidata:SPARQL_query_service/2016_SPARQL_Workshop)
#' - [Wikidata SPARQL Query video tutorial](https://www.youtube.com/watch?v=1jHoUkj_mKw)
#'   by Navino Evans
#' - _[Learning SPARQL](http://www.learningsparql.com/)_ by Bob DuCharme
#' - [WDQS User Manual](https://www.mediawiki.org/wiki/Wikidata_query_service/User_Manual)
#' @aliases WDQS
#' @docType package
#' @name WDQS-package
NULL
