% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShadedDensity.R
\name{ShadedDensityCenter}
\alias{ShadedDensityCenter}
\title{Plot the distribution of a variable with a center region shaded}
\usage{
ShadedDensityCenter(frame, xvar, boundaries, title, ...,
  linecolor = "darkgray", shading = "darkblue", annotate_area = TRUE)
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar}{name of the variable to be density plotted}

\item{boundaries}{vector of the min and max boundaries of the shaded region}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{linecolor}{color of density curve}

\item{shading}{color of shaded region and boundaries}

\item{annotate_area}{if TRUE (default), report the area of the shaded region}
}
\description{
Plot the distribution of a variable with a center region shaded. Annotate with the area of the shaded region.
}
\examples{

set.seed(52523)
d = data.frame(meas=rnorm(100))
boundaries = c(-1.5, 1.5)
WVPlots::ShadedDensityCenter(d, "meas", boundaries,
                       title="Example center-shaded density plot")

}
\seealso{
\code{\link{ShadedDensity}}
}
