% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solveMixtureExponentialDistribution.R
\name{solveMixtureExponentialDistribution}
\alias{solveMixtureExponentialDistribution}
\title{Solve Parameters in a Mixture Exponential Distribution}
\usage{
solveMixtureExponentialDistribution(
  weight1,
  median1,
  median2 = NULL,
  overall_median = NULL
)
}
\arguments{
\item{weight1}{numeric. The proportion of the first component.}

\item{median1}{numeric. Median of the first component.}

\item{median2}{numeric. Median of the second component. If \code{NULL},
then \code{overall_median} must be specified, and this function will
calculate and return \code{median2}.}

\item{overall_median}{numeric. Median of the overall population. If
\code{NULL}, then \code{median2} must be specified, and this function
will calculate and return \code{overall_median}.}
}
\value{
a named vector of \code{median2} or \code{overall_median}.
}
\description{
This is a helper function to explore parameters for endpoint generator,
likely in an enrichment design.

Assume that the overall population in an arm is a mixture of two exponential
distributions with medians \code{median1} (\eqn{m_1}) and
\code{median2} (\eqn{m_2}). Given the proportion of the first component
(\eqn{p_1}) and the overall median \eqn{m}, we have

\deqn{p_1 (1 - e^{-\log(2)m/m_1}) + (1 - p_1) (1 - e^{-\log(2)m/m_2}) = 1/2}

This function computes \eqn{m_2} or \eqn{m} given \eqn{p_1} and \eqn{m_1}.
These parameters can be used in custom random number generator to define
exponential distributed endpoints.

Note that the math formula above may not be displayed correctly on a
html page. You can read it with better format by running
\code{?solveMixtureExponentialDistribution}.
}
\examples{

library(dplyr)

median2 <-
  solveMixtureExponentialDistribution(
    weight1 = .3,
    median1 = 10,
    overall_median = 8)

median2

n <- 1e6
ifelse(
  runif(n) < .3,
  rexp(n, rate=log(2)/10),
  rexp(n, rate=log(2)/median2)) \%>\%
  median() ## should be close to 8

overall_median <-
  solveMixtureExponentialDistribution(
    weight1 = .4,
    median1 = 12,
    median2 = 4)

overall_median

ifelse(
  runif(n) < .4,
  rexp(n, rate=log(2)/12),
  rexp(n, rate=log(2)/4)) \%>\%
  median() ## should be close to overall_median

}
