% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimFunctions.R
\name{SimFunctions}
\alias{SimFunctions}
\title{Template-based generation of the Generate-Analyse-Summarise functions}
\usage{
SimFunctions(
  filename = NULL,
  dir = getwd(),
  save_structure = "single",
  extra_file = FALSE,
  nAnalyses = 1,
  nGenerate = 1,
  summarise = TRUE,
  comments = FALSE,
  openFiles = TRUE,
  spin_header = TRUE,
  SimSolve = FALSE
)
}
\arguments{
\item{filename}{a character vector indicating whether the output should be saved to two respective files
containing the simulation design and the functional components, respectively. Using this option
is generally the recommended approach when beginning to write a Monte Carlo simulation}

\item{dir}{the directory to write the files to. Default is the working directory}

\item{save_structure}{character indicating the number of files to break the simulation code into
when \code{filename} is included (default is 'single' for one file). When \code{save_structure = 'double'} the
output is saved to two separate files containing the functions and design definitions,
and when \code{save_structure = 'all'} the generate, analyse, summarise, and execution code area all saved into
separate files. The purpose for this structure is because multiple structured files
often makes organization and debugging slightly easier larger Monte Carlo simulations, though in principle
all files could be stored into a single R script}

\item{extra_file}{logical; should and extra file be saved containing user-defined functions or objects?
Default is \code{FALSE}}

\item{nAnalyses}{number of analysis functions to create (default is 1). Increasing the value
of this argument when independent analysis are being performed allows function definitions
to be better partitioned and potentially more modular}

\item{nGenerate}{number of generate functions to create (default is 1). Increase the value
of this argument when when the data generation functions are very different and should
be isolated from each other (otherwise, if there is much in common between the generate
steps, the default of 1 should be preferred). Otherwise, if \code{nGenerate == 0}
then no generate function will be provided and instead this data-generation
step can be defined in the analysis function(s) (only recommended for smaller simulations)}

\item{summarise}{include \code{summarise} function? Default is \code{TRUE}}

\item{comments}{logical; include helpful comments? Default is \code{FALSE}}

\item{openFiles}{logical; after files have been generated, open them in your text editor
(e.g., if Rstudio is running the scripts will open in a new tab)?}

\item{spin_header}{logical; include a basic \code{knitr::spin} header to allow the simulation
to be knitted? Default is \code{TRUE}. For those less familiar with \code{spin} documents
see \code{https://bookdown.org/yihui/rmarkdown-cookbook/spin.html} for further details}

\item{SimSolve}{logical; should the template be generated that is intended for a
\code{\link{SimSolve}} implementation? Default is \code{FALSE}}
}
\description{
This function prints template versions of the required \code{Design} and Generate-Analyse-Summarise functions
for \code{SimDesign} to run simulations. Templated output comes complete with the correct inputs,
class of outputs, and optional comments to help with the initial definitions.
Use this at the start of your Monte Carlo simulation study. Following
the definition of the \code{SimDesign} template file please refer to detailed the information
in \code{\link{runSimulation}} for how to edit this template to make a working simulation study.
}
\details{
The recommended approach to organizing Monte Carlo simulation files is to first save the template generated
by this function to the hard-drive by passing a suitable \code{filename} argument
(which, if users are interacting
with R via the RStudio IDE, will also open the template file after it has been saved).
For larger simulations, two
separate files could also be used (achieved by changing \code{out.files}),
and may be easier for debugging/sourcing the simulation code; however, this is a
matter of preference and does not change any functionality in the package.
}
\examples{

SimFunctions()
SimFunctions(comments = TRUE) #with helpful comments

\dontrun{

# write output files to a single file with comments
SimFunctions('mysim', comments = TRUE)

# Multiple analysis functions for optional partitioning
SimFunctions(nAnalyses = 2)
SimFunctions(nAnalyses = 3)

# Multiple analysis + generate functions
SimFunctions(nAnalyses = 2, nGenerate=2)

# save multiple files for the purpose of designing larger simulations
#  (also include extra_file for user-defined objects/functions)
SimFunctions('myBigSim', save_structure = 'all',
   nAnalyses = 3, nGenerate=2, extra_file = TRUE)


}

}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\seealso{
\code{\link{runSimulation}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
