% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{FRiP}
\alias{FRiP}
\title{Calculate fraction of reads in peaks per cell}
\usage{
FRiP(object, assay, total.fragments, col.name = "FRiP", verbose = TRUE)
}
\arguments{
\item{object}{A Seurat object}

\item{assay}{Name of the assay containing a peak x cell matrix}

\item{total.fragments}{Name of a metadata column containing the total number
of sequenced fragments for each cell. This can be computed using the
\code{\link{CountFragments}} function.}

\item{col.name}{Name of column in metadata to store the FRiP information.}

\item{verbose}{Display messages}
}
\value{
Returns a \code{\link[Seurat]{Seurat}} object
}
\description{
Calculate fraction of reads in peaks per cell
}
\examples{
FRiP(object = atac_small, assay = 'peaks', total.fragments = "fragments")
}
\concept{qc}
