% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{LocalStruct}
\alias{LocalStruct}
\title{Calculate the local structure preservation metric}
\usage{
LocalStruct(object, grouping.var, idents = NULL, neighbors = 100,
  reduction = "pca", reduced.dims = 1:10, orig.dims = 1:10,
  verbose = TRUE)
}
\arguments{
\item{object}{Seurat object}

\item{grouping.var}{Grouping variable}

\item{idents}{Optionally specify a set of idents to compute metric for}

\item{neighbors}{Number of neighbors to compute in pca/corrected pca space}

\item{reduction}{Dimensional reduction to use for corrected space}

\item{reduced.dims}{Number of reduced dimensions to use}

\item{orig.dims}{Number of PCs to use in original space}

\item{verbose}{Display progress bar}
}
\value{
Returns the average preservation metric
}
\description{
Calculates a metric that describes how well the local structure of each group
prior to integration is preserved after integration. This procedure works as
follows: For each group, compute a PCA, compute the top num.neighbors in pca
space, compute the top num.neighbors in corrected pca space, compute the
size of the intersection of those two sets of neighbors.
Return the average over all groups.
}
