% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-standard_curve.R
\name{plot_standard_curve_stacked}
\alias{plot_standard_curve_stacked}
\title{Standard curve stacked plot for levey-jennings report}
\usage{
plot_standard_curve_stacked(
  list_of_plates,
  analyte_name,
  data_type = "Median",
  decreasing_dilution_order = TRUE,
  monochromatic = TRUE,
  legend_type = NULL,
  plot_legend = TRUE,
  legend_position = "bottom",
  max_legend_items_per_row = 3,
  legend_text_size = 8,
  sort_plates = TRUE,
  log_scale = c("all"),
  verbose = TRUE
)
}
\arguments{
\item{list_of_plates}{list of Plate objects}

\item{analyte_name}{Name of the analyte of which standard curves we want to plot.}

\item{data_type}{Data type of the value we want to plot - the same
datatype as in the plate file. By default equals to \code{Median}}

\item{decreasing_dilution_order}{If \code{TRUE} the dilution values are
plotted in decreasing order, \code{TRUE} by default}

\item{monochromatic}{If \code{TRUE} the color of standard curves changes
from white (the oldest) to blue (the newest) it helps to observe drift in
calibration of the device; otherwise, more varied colours are used, \code{TRUE} by default}

\item{legend_type}{default value is \code{NULL}, then legend type is determined
based on monochromatic value. If monochromatic is equal to \code{TRUE} then legend
type is set to \code{date}, if it is \code{FALSE} then legend
type is set to \code{plate_name}. User can override this behavior by
setting explicitly \code{legend_type} to \code{date} or \code{plate_name}.}

\item{plot_legend}{If \code{TRUE} the legend is plotted, \code{TRUE} by default}

\item{legend_position}{the position of the legend, a possible values are \code{c(right, bottom, left, top, none)}. Is not used if \code{plot_legend} equals to \code{FALSE}.}

\item{max_legend_items_per_row}{Maximum number of legend items per row when legend is at top or bottom. Default is 3.}

\item{legend_text_size}{Font size of the legend. Can be useful if plotting long plate names. Default is 8}

\item{sort_plates}{(\code{logical(1)}) if \code{TRUE} sorts plates by the date of examination.}

\item{log_scale}{Which elements on the plot should be displayed in log scale.
By default \code{"all"}. If \code{NULL} or \code{c()} no log scale is used,
if \code{"all"} or \code{c("dilutions", "MFI")} all elements are displayed in log scale.}

\item{verbose}{If \code{TRUE} prints messages, \code{TRUE} by default}
}
\value{
ggplot object with the plot
}
\description{
As a quality control measure to detect plates with inconsistent results or drift in calibration over time,
this function plots standard curves for a specified analyte across multiple plates on a single plot.
It enables visual comparison of standard curves, making it easier to spot outliers or shifts in calibration.
The function can be run standalone or used as part of a broader Levey-Jennings report.

Each curve represents one plate, and users can choose how colours are applied — either in a
monochromatic blue gradient (indicating time-based drift) or with distinct hues for clearer differentiation.
}
\details{
The function overlays all standard curves from the provided plates for the given analyte.
When \code{monochromatic = TRUE}, the curves are drawn in a blue gradient — oldest plates in light blue (almost white) and most recent ones in dark blue.
This visual encoding helps track drift in calibration over time.

When \code{monochromatic = FALSE}, colours are selected from a hue palette to ensure distinct appearance,
especially useful when comparing many plates simultaneously.

The \code{legend_type} determines how curves are identified in the legend. By default, it adapts based on the \code{monochromatic} setting.

If the legend becomes crowded (e.g., with long plate names), use \code{max_legend_items_per_row} and \code{legend_text_size} to improve layout and readability.
}
\examples{

# creating temporary directory for the example
output_dir <- tempdir(check = TRUE)

dir_with_luminex_files <- system.file("extdata", "multiplate_reallife_reduced",
  package = "SerolyzeR", mustWork = TRUE
)
list_of_plates <- process_dir(dir_with_luminex_files,
  return_plates = TRUE, format = "xPONENT", output_dir = output_dir
)
plot_standard_curve_stacked(list_of_plates, "ME", data_type = "Median", monochromatic = FALSE)

}
