% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saga_tools.R
\name{tidy.saga_tool}
\alias{tidy.saga_tool}
\title{Summarize the parameters that are available within a SAGA-GIS tool and
return these as a tibble.}
\usage{
\method{tidy}{saga_tool}(x, ...)
}
\arguments{
\item{x}{a `saga_tool` object}

\item{...}{additional arguments. Currently unused.}
}
\value{
a tibble that describes tools, identifiers used by the saga_cmd
  command line tool, the equivalent argument name used by Rsagacmd, and other
  options and descriptions.
}
\description{
Summarize the parameters that are available within a SAGA-GIS tool and
return these as a tibble.
}
\examples{
\dontrun{
# Initialize a saga object
saga <- saga_gis()

# tidy the tools parameters into a tibble
tidy(saga$ta_morphometry$slope_aspect_curvature)
}
}
