% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/products.update.R
\name{products.update}
\alias{products.update}
\title{Update a product}
\usage{
products.update(id, name = NULL, code = NULL, unit = NULL,
  tax = NULL, active_flag = NULL, visible_to = NULL,
  owner_id = NULL, prices = NULL, customList = NULL,
  api_token = NULL, company_domain = "api",
  return_type = c("complete", "boolean"))
}
\arguments{
\item{id}{ID of the product}

\item{name}{Name of the product.}

\item{code}{Product code.}

\item{unit}{Unit in which this product is sold}

\item{tax}{Tax percentage}

\item{active_flag}{Whether this product will be made active or not. This field has the following domains: (0; 1)}

\item{visible_to}{Visibility of the product. If omitted, visibility will be set to the default visibility setting of this item type for the authorized user.1 = Owner & followers (private); 3 = Entire company (shared) This field has the following domains: (1; 3)}

\item{owner_id}{ID of the user who will be marked as the owner of this product. When omitted, the authorized user ID will be used.}

\item{prices}{Array of objects, each containing: currency (string), price (number), cost (number, optional), overhead_cost (number, optional). Note that there can only be one price per product per currency. When 'prices' is omitted altogether, product pricing will not be changed.}

\item{customList}{List with custom fields. Example: list(`custom_field` = abc)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Update a product on pipedrive.
}
\examples{
\donttest{
products.update(id='e.g.',api_token='token',company_domain='exp')
}
}
