% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persons.update.R
\name{persons.update}
\alias{persons.update}
\title{Update a person}
\usage{
persons.update(id, name = NULL, owner_id = NULL, org_id = NULL,
  email = NULL, phone = NULL, visible_to = NULL, customList = NULL,
  api_token = NULL, company_domain = "api",
  return_type = c("complete", "boolean"))
}
\arguments{
\item{id}{Person ID}

\item{name}{Person name}

\item{owner_id}{ID of the user who will be marked as the owner of this person. When omitted, the authorized user ID will be used.}

\item{org_id}{ID of the organization this person will belong to.}

\item{email}{Email addresses (one or more) associated with the person, presented in the same manner as received by GET request of a person.}

\item{phone}{Phone numbers (one or more) associated with the person, presented in the same manner as received by GET request of a person.}

\item{visible_to}{Visibility of the person. If omitted, visibility will not be changed.1 = Owner & followers (private); 3 = Entire company (shared) This field has the following domains: (1; 3)}

\item{customList}{List with custom fields. Example: list(`custom_field` = abc)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Update a person on pipedrive.
}
\examples{
\donttest{
persons.update(id='e.g.',api_token='token',company_domain='exp')
}
}
