% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F.gx.estim.r
\name{F.gx.estim}
\alias{F.gx.estim}
\title{F.gx.estim - Estimate g(0) or g(x)}
\usage{
F.gx.estim(fit, x.scl = NULL, g.x.scl = NULL, observer = NULL)
}
\arguments{
\item{fit}{An estimated \code{dfunc} object.  See \code{dfuncEstim}.}

\item{x.scl}{The x coordinate (a distance) at which to scale the 
sightability function to \code{g.x.scl}, or the string "max".  
When \code{x.scl} is specified (i.e., not 0 or "max"), it must have measurement 
units assigned using either \code{library(units);units(x.scl) <- '<units>'}
or \code{x.scl <- units::set_units(x.scl, <units>)}. See
\code{units::valid_udunits()} for valid symbolic units. See 
Details for more on 
scaling the sightability function.}

\item{g.x.scl}{Height of the distance function at coordinate \emph{x}. 
The distance function 
will be scaled so that g(\code{x.scl}) = \code{g.x.scl}. 
If \code{g.x.scl} is not 
a data frame, it must be a numeric value (vector of length 1) 
between 0 and 1. 
See Details.}

\item{observer}{A numeric scalar or text string specifying whether observer 1 
or observer 2 or both were full-time observers. 
This parameter dictates which set of observations form the denominator 
of a double observer system.   
If, for example, observer 2 was a data recorder and part-time observer, 
or if observer 2 was the pilot, set \code{observer} = 1.  
If \code{observer} = 1, observations by observer 1 not seen 
by observer 2 are ignored. The estimate of detection in this case is the 
ratio of number of targets seen by both observers 
to the number seen by both plus the number seen by just observer 2. 
If observer = "both", the 
computation goes both directions.}
}
\value{
A list comprised of the following components:
  \item{x.scl}{The value of x (distance) at which g() is evaluated.  }
  \item{comp2 }{The estimated value of g() when evaluated at \code{x.scl}.  }
}
\description{
Estimate g(0) or g(x) for a specified distance function.
}
\details{
This routine scales sightability such that 
g(\code{x.scl}) = \code{g.x.scl}, where g() is the sightability function.
Specification of \code{x.scl} and \code{g.x.scl} covers several estimation cases:
\enumerate{  
  \item \bold{g(0) = 1} : (the default) Inputs are \code{x.scl} = 0, \code{g.x.scl} = 1. 
  If \code{w.lo} > 0, \code{x.scl} will be set to \code{w.lo}
  so technically this case is g(\code{w.low}) = 1.
  
  \item \bold{User supplied probability at specified distance}: Inputs are 
  \code{x.scl} = a number greater than or equal 
  to \code{w.lo}, \code{g.x.scl} = a number between 0 and 1.  This case 
  covers situations where sightability on the transect (distance 0) is 
  not perfect.  This case  assumes researchers have an independent 
  estimate of sightability at distance 
  \code{x.scl} off the transect.  For example, researchers could be
  using multiple 
  observers to estimate that sightability at distance \code{x.scl} 
  is \code{g.x.scl}. 
  
  \item \bold{Maximum sightability specified}: Inputs 
  are \code{x.scl}="max", \code{g.x.scl} =  a number 
  between 0 and 1.  In this case, 
  g() is scaled such that its maximum value is \code{g.x.scl}.  
  This routine computes the distance at which g() is maximum, sets 
  g()'s height there to \code{g.x.scl}, and returns \code{x.max} where 
  x.max is the distance at which g is maximized. This case covers the 
  common aerial survey situation where maximum sightability is slightly 
  off the transect, but the distance at which the maximum occurs 
  is unknown. This case is the default, with \code{g.x.scl} = 1, 
  when gamma distance functions are estimated. 
  
  \item \bold{Double observer system}: Inputs are 
  \code{x.scl}="max", \code{g.x.scl} = <a data frame>. 
  In this case, g(\emph{x}) = \emph{h}, where \emph{x} is the distance that 
  maximizes g and \emph{h} is the height of g() at \emph{x} 
  computed from the double observer data frame (see below for 
  structure of the double observer data frame).
  
  
  \item \bold{Distance of independence specified, height computed from double 
  observer system}: Inputs are 
  \code{x.scl} = a number greater than or equal to \code{w.lo}
  \code{g.x.scl} = a data frame.  In this case, g(\code{x.scl}) = \emph{h}, 
  where \emph{h} is computed from the double observer data frame 
  (see below for structure of the double observer data frame). 

}   
  
  When \code{x.scl}, \code{g.x.scl}, or \code{observer} are NULL, the routine 
  will look for and use \code{$call.x.scl}, or \code{$call.g.x.scl}, or 
  \code{$call.observer} components of the \code{fit} object for whichever 
  of these three parameters is missing.  Later, different 
  values can be specified in a direct call to \code{F.gx.estim} 
  without having to re-estimate the distance function. Because of this feature, 
  the default values in \code{dfuncEstim} are \code{x.scl} = 0 and 
  \code{g.x.scl} = 1 and \code{observer} = "both".
}
\section{Structure of the double observer data frame}{
  
When \code{g.x.scl} is a data frame, it is assumed to contain 
  the components \code{$obsby.1} and \code{$obsby.2} (no flexibility on names). 
  Each row in the data frame contains data from one sighted target. 
  The \code{$obsby.1} and \code{$obsby.2} components are 
  TRUE/FALSE (logical) vectors indicating whether 
  observer 1 (\code{obsby.1}) or observer 2 (\code{obsby.2}) spotted the target.
}

\examples{
  set.seed(555574)
  x <- rnorm(1000) * 100
  x <- x[ 0 < x & x < 100 ]
  x <- units::set_units(x, "m")
  un.dfunc <- dfuncEstim( x ~ 1
                       , likelihood = "logistic")    
  F.gx.estim(un.dfunc)
  
  x <- rgamma(1000, shape = 5)
  x <- units::set_units(x, "m")
  gam.dfunc <- dfuncEstim( x ~ 1
                         , likelihood="Gamma")    
  F.gx.estim(gam.dfunc)
  
}
\seealso{
\code{\link{dfuncEstim}}
}
\keyword{model}
