/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.estimate;

import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.core.RevisionUtils;
import weka.estimators.DiscreteEstimator;

public class DiscreteEstimatorFullBayes
extends DiscreteEstimatorBayes {
    static final long serialVersionUID = 6774941981423312133L;

    public DiscreteEstimatorFullBayes(int nSymbols, double w1, double w2, DiscreteEstimatorBayes EmptyDist, DiscreteEstimatorBayes ClassDist, double fPrior) {
        super(nSymbols, fPrior);
        this.m_SumOfCounts = 0.0;
        for (int iSymbol = 0; iSymbol < this.m_nSymbols; ++iSymbol) {
            double p1 = EmptyDist.getProbability(iSymbol);
            double p2 = ClassDist.getProbability(iSymbol);
            this.m_Counts[iSymbol] = w1 * p1 + w2 * p2;
            this.m_SumOfCounts += this.m_Counts[iSymbol];
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }

    public static void main(String[] argv) {
        try {
            int current;
            if (argv.length == 0) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            int max = current = Integer.parseInt(argv[0]);
            for (int i = 1; i < argv.length; ++i) {
                current = Integer.parseInt(argv[i]);
                if (current <= max) continue;
                max = current;
            }
            DiscreteEstimator newEst = new DiscreteEstimator(max + 1, true);
            for (int i = 0; i < argv.length; ++i) {
                current = Integer.parseInt(argv[i]);
                System.out.println(newEst);
                System.out.println("Prediction for " + current + " = " + newEst.getProbability(current));
                newEst.addValue(current, 1.0);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

