\name{print.sienaMeta}
\alias{print.sienaMeta}
\alias{sienaMeta}
\alias{summary.sienaMeta}
\alias{plot.sienaMeta}
\alias{print.summary.sienaMeta}
\title{Methods for processing sienaMeta objects}
\usage{
\method{print}{sienaMeta}(x, file=FALSE, ...)

\method{summary}{sienaMeta}(object, file=FALSE, extra=TRUE, ...)

\method{print}{summary.sienaMeta}(x, file=FALSE, extra=TRUE, ...)

\method{plot}{sienaMeta}(x,  ..., layout=c(2,2))
}
\description{
  \code{print}, \code{summary}, and \code{plot} methods for
   \code{sienaMeta} objects.
}
\arguments{
  \item{object}{An object of class \code{sienaMeta}}
  \item{x}{An object of class \code{sienaMeta}, or
	\code{summary.sienaMeta} as appropriate}
  \item{file}{Boolean: if TRUE, sends output to file named
	\code{x$projname.out}. If FALSE, output is to the terminal.}
	\item{extra}{Boolean: if TRUE, prints more information}
  \item{layout}{the vector giving number of rows and columns
       in the arrangement of the several panels in a
       rectangular array, possibly spanning multiple pages}
  \item{\dots}{For extra arguments (none used at present)
}
}
\value{
 The function \code{print.sienaMeta} prints details of the merged
 estimates of the meta-analysis, with test statistics.

 The function \code{summary.sienaMeta} prints details as for the
 \code{print} method, but also details of the \code{sienaFit} objects
 included.

 Output from either can be directed to a file by using the argument
 \code{file}. It will be appended to any existing file of the same
 name: \code{projname.out}  where \code{projname} is the value of the
 argument to \code{siena08}.

 The function \code{plot.sienaMeta} plots estimates against standard
 errors for each effect, with reference lines added at the two-sided
 significance threshold 0.05. It returns an object of class \code{trellis},
 of the \code{\link{lattice}}.package. Effects for which a score test
 was requested are not plotted.
}
\references{
  T. A. B. Snijders and Chris Baerveldt.
  "Multilevel network study of the effects
  of delinquent behavior on friendship
  evolution". \emph{Journal of Mathematical Sociology}, 27: 123--151, 2003.

  See also the Siena manual and
  \url{http://www.stats.ox.ac.uk/~snijders/siena/}
}
\author{Ruth Ripley, Tom Snijders
}

\examples{
\dontrun{
# A meta-analysis for three groups does not make much sense
# for generalizing to a population of networks,
# but it the Fisher combinations of p-values are meaningful.
# But using three groups shows the idea.

Group1 <- sienaDependent(array(c(N3401, HN3401), dim=c(45, 45, 2)))
Group3 <- sienaDependent(array(c(N3403, HN3403), dim=c(37, 37, 2)))
Group4 <- sienaDependent(array(c(N3404, HN3404), dim=c(33, 33, 2)))
dataset.1 <- sienaDataCreate(Friends = Group1)
dataset.3 <- sienaDataCreate(Friends = Group3)
dataset.4 <- sienaDataCreate(Friends = Group4)
OneAlgorithm <- sienaAlgorithmCreate(projname = 'SingleGroups')
effects.1 <- getEffects(dataset.1)
effects.3 <- getEffects(dataset.3)
effects.4 <- getEffects(dataset.4)
effects.1 <- includeEffects(effects.1, transTrip)
effects.1 <- setEffect(effects.1, cycle3, fix=TRUE, test=TRUE)
effects.3 <- includeEffects(effects.3, transTrip)
effects.3 <- setEffect(effects.3, cycle3, fix=TRUE, test=TRUE)
effects.4 <- includeEffects(effects.4, transTrip)
effects.4 <- setEffect(effects.4, cycle3, fix=TRUE, test=TRUE)
ans.1 <- siena07(OneAlgorithm, data=dataset.1, effects=effects.1, batch=TRUE)
ans.3 <- siena07(OneAlgorithm, data=dataset.3, effects=effects.3, batch=TRUE)
ans.4 <- siena07(OneAlgorithm, data=dataset.4, effects=effects.4, batch=TRUE)
ans.1
ans.3
ans.4
(meta <- siena08(ans.1, ans.3, ans.4))
summary(meta)
plo <- plot(meta, layout = c(3,1))
plo
plo[3]
}}
\keyword{ methods }
