% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankNormal.R
\name{BootCorr}
\alias{BootCorr}
\title{Bootstrap Correlation Estimate.}
\usage{
BootCorr(y, G, X, S, k = 3/8, B = 100, parallel)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Obs by snp genotype matrix.}

\item{X}{Model matrix of covariates.}

\item{S}{Model matrix of structure adjustments.}

\item{k}{Offset applied during rank-normalization. See
\code{\link{rankNormal}}.}

\item{B}{Bootstrap samples for correlation estimation.}

\item{parallel}{Run bootstraps in parallel? Must register parallel backend first.}
}
\value{
Numeric matrix of correlation estimates, one per locus (column) in G.
}
\description{
Estimates the correlation between correlated p-values on the Z-score scale.
Avoids the assumption that the correlation between p-values is constant across
loci. Instead, bootstrap is used to calculate locus-specific estimates of the
correlation between p-values.
}
