/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ucarima;

import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.AutoCovarianceFunction;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.LinearModel;
import ec.tstoolkit.arima.StationaryTransformation;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.ForeFilter;
import ec.tstoolkit.maths.linearfilters.RationalBackFilter;
import ec.tstoolkit.maths.linearfilters.RationalFilter;
import ec.tstoolkit.maths.linearfilters.RationalForeFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.ucarima.UcarimaModel;
import ec.tstoolkit.ucarima.WienerKolmogorovEstimator;

public class WienerKolmogorovEstimators {
    private final UcarimaModel m_ucm;
    private WienerKolmogorovEstimator[][] m_final;

    public WienerKolmogorovEstimators(UcarimaModel ucm) {
        this.m_ucm = ucm.clone();
    }

    private void calcestimator(int cmp, boolean signal) throws ArimaException, MatrixException {
        int k;
        if (this.m_ucm == null) {
            return;
        }
        int n = k = signal ? 1 : 0;
        if (this.m_final == null) {
            this.m_final = new WienerKolmogorovEstimator[this.m_ucm.getComponentsCount()][2];
        } else if (this.m_final[cmp][k] != null) {
            return;
        }
        ArimaModel a = this.m_ucm.getComponent(cmp);
        ArimaModel s = signal ? a : this.m_ucm.getComplement(cmp);
        BackFilter nar = this.m_ucm.getModel().getStationaryAR();
        BackFilter dar = s.getStationaryAR();
        BackFilter nur = this.m_ucm.getModel().getNonStationaryAR();
        BackFilter dur = s.getNonStationaryAR();
        BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool(false);
        if (smp.simplify(nar, dar)) {
            nar = (BackFilter)smp.getLeft();
            dar = (BackFilter)smp.getRight();
        }
        nur = nur.divide(dur);
        nar = nar.times(nur);
        BackFilter denom = this.m_ucm.getModel().getMA().times(dar);
        BackFilter num = s.getMA().times(nar);
        SymmetricFilter c = SymmetricFilter.createFromFilter(num);
        double svar = s.getInnovationVariance();
        double mvar = this.m_ucm.getModel().getInnovationVariance();
        c = c.times(svar / mvar);
        BackFilter gf = c.decompose(denom);
        RationalBackFilter rb = new RationalBackFilter(gf, denom);
        RationalFilter f = new RationalFilter(rb, rb.mirror(), c, SymmetricFilter.createFromFilter(denom));
        RationalFilter mf = new RationalFilter(s.getMA().times(svar / mvar), s.getAR(), num.mirror(), denom.mirror());
        LinearModel m = new LinearModel(mf, mvar);
        this.m_final[cmp][k] = new WienerKolmogorovEstimator(f, m);
    }

    public ArimaModel finalErrorModel(int cmp) throws ArimaException {
        if (this.m_ucm == null) {
            return null;
        }
        ArimaModel s = this.m_ucm.getComponent(cmp);
        if (s.isNull()) {
            return null;
        }
        ArimaModel n = this.m_ucm.getComplement(cmp);
        IArimaModel model = this.m_ucm.getModel();
        BackFilter ar = model.getMA();
        SymmetricFilter ss = s.sma();
        SymmetricFilter sn = n.sma();
        SymmetricFilter num = ss.times(sn);
        return new ArimaModel(ar, null, num);
    }

    public WienerKolmogorovEstimator finalEstimator(int cmp, boolean signal) throws ArimaException, MatrixException {
        if (this.m_ucm == null) {
            return null;
        }
        ArimaModel a = this.m_ucm.getComponent(cmp);
        if (a.isNull()) {
            return null;
        }
        this.calcestimator(cmp, signal);
        return this.m_final[cmp][signal ? 1 : 0];
    }

    public StationaryTransformation finalStationaryEstimator(int cmp, boolean signal) throws ArimaException {
        ArimaModel a;
        if (this.m_ucm == null) {
            return null;
        }
        IArimaModel model = this.m_ucm.getModel();
        ArimaModel arimaModel = a = signal ? this.m_ucm.getComponent(cmp) : this.m_ucm.getComplement(cmp);
        if (a.isNull()) {
            return null;
        }
        BackFilter nar = this.m_ucm.getModel().getStationaryAR();
        BackFilter dar = a.getStationaryAR();
        BackFilter nur = this.m_ucm.getModel().getNonStationaryAR();
        BackFilter dur = a.getNonStationaryAR();
        BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool(false);
        if (smp.simplify(nar, dar)) {
            nar = (BackFilter)smp.getLeft();
            dar = (BackFilter)smp.getRight();
        }
        nur = nur.divide(dur);
        nar = nar.times(nur);
        BackFilter denom = model.getMA().times(dar);
        BackFilter num = a.getMA().times(nar);
        double avar = a.getInnovationVariance();
        double mvar = model.getInnovationVariance();
        BackFilter star = a.getStationaryAR();
        BackFilter ur = a.getNonStationaryAR();
        RationalFilter mf = new RationalFilter(a.getMA().times(avar / mvar), star, num.mirror(), denom.mirror());
        return new StationaryTransformation(new LinearModel(mf, mvar), ur);
    }

    public UcarimaModel getUcarimaModel() {
        return this.m_ucm;
    }

    public LinearModel revisionModel(int cmp, int n) throws ArimaException, MatrixException {
        if (n < 0) {
            return null;
        }
        LinearModel ln = this.finalEstimator(cmp, true).getModel();
        RationalFilter rf = ln.getFilter();
        RationalForeFilter rff = rf.getRationalForeFilter().drop(n + 1);
        ForeFilter num = rff.getNumerator();
        ForeFilter denom = rff.getDenominator();
        RationalFilter crf = new RationalFilter(new RationalBackFilter(), new RationalForeFilter(num, denom));
        return new LinearModel(crf, ln.getInnovationVariance());
    }

    public AutoCovarianceFunction totalErrorAcf(int cmp, int n) {
        LinearModel rev = this.revisionModel(cmp, n);
        ArimaModel fm = this.finalErrorModel(cmp);
        RationalForeFilter rf = rev.getFilter().getRationalForeFilter();
        BackFilter rnum = rf.getNumerator().mirror();
        double n0 = rnum.get(0);
        ArimaModel rm = new ArimaModel(rf.getDenominator().mirror(), null, rnum.normalize(), rev.getInnovationVariance() * n0 * n0);
        return fm.plus(rm).getAutoCovarianceFunction();
    }

    public AutoCovarianceFunction revisionAcf(int cmp, int n) {
        LinearModel rev = this.revisionModel(cmp, n);
        return rev.getAutoCovarianceFunction();
    }

    public double[] revisionVariance(int cmp, boolean signal, int start, int n) throws ArimaException, MatrixException {
        double w;
        int i;
        if (this.m_ucm.getComponent(cmp).isNull()) {
            return null;
        }
        double[] rvar = new double[n];
        double var0 = this.revisionModel(cmp, 0).getAutoCovarianceFunction().get(0);
        LinearModel lm = this.finalEstimator(cmp, signal).getModel();
        RationalFilter rf = lm.getFilter();
        double mvar = lm.getInnovationVariance();
        if (start <= 0 && -start < n) {
            rvar[-start] = var0;
        }
        double var = var0;
        for (i = -1; i >= start; --i) {
            w = rf.getWeight(i + 1);
            var += w * w * mvar;
            if (i - start >= n) continue;
            rvar[i - start] = var;
        }
        var = var0;
        for (i = 1; i < start; ++i) {
            w = rf.getWeight(i);
            if (!((var -= w * w * mvar) <= 0.0)) continue;
            return rvar;
        }
        for (i = Math.max(start, 1); i < n + start && !((var -= (w = rf.getWeight(i)) * w * mvar) <= 0.0); ++i) {
            rvar[i - start] = var;
        }
        return rvar;
    }

    public double[] relativeRevisionVariance(int cmp, boolean signal, int start, int n) throws ArimaException, MatrixException {
        if (this.m_ucm.getComponent(cmp).isNull()) {
            return null;
        }
        double[] rvar = new double[n];
        LinearModel lm = this.finalEstimator(cmp, signal).getModel();
        RationalFilter rf = lm.getFilter();
        double mvar = lm.getInnovationVariance();
        double var = 0.0;
        for (int i = 1; i < n; ++i) {
            double w = rf.getWeight(i + start);
            rvar[i] = var += w * w * mvar;
        }
        return rvar;
    }

    public double[] totalErrorVariance(int cmp, boolean signal, int start, int n) throws ArimaException, MatrixException {
        if (this.m_ucm.getComponent(cmp).isNull()) {
            return null;
        }
        double[] tvar = this.revisionVariance(cmp, signal, start, n);
        double fvar = this.finalErrorModel(cmp).getAutoCovarianceFunction().get(0);
        int i = 0;
        while (i < tvar.length) {
            int n2 = i++;
            tvar[n2] = tvar[n2] + fvar;
        }
        return tvar;
    }

    public double variationPrecision(int cmp, int start, int del, boolean all) {
        if (this.m_ucm.getComponent(cmp).isNull()) {
            return Double.NaN;
        }
        LinearModel me = this.finalEstimator(cmp, true).getModel();
        RationalFilter fe = me.getFilter();
        double mv = me.getInnovationVariance();
        AutoCovarianceFunction acf = all ? this.totalErrorAcf(cmp, start) : this.revisionAcf(cmp, start);
        double v = 2.0 * (acf.get(0) - acf.get(del));
        for (int i = 0; i < del; ++i) {
            double x = fe.getWeight(i + start + 1);
            v -= x * x * mv;
        }
        return v;
    }

    public double variationRevisionVariance(int cmp, int start, int del, int nrevs) {
        if (this.m_ucm.getComponent(cmp).isNull()) {
            return Double.NaN;
        }
        LinearModel me = this.finalEstimator(cmp, true).getModel();
        RationalFilter fe = me.getFilter();
        double mv = me.getInnovationVariance();
        double v = 0.0;
        for (int i = 1; i <= nrevs; ++i) {
            double x = fe.getWeight(i + start);
            double y = fe.getWeight(i + start + del);
            v += x * x + y * y - 2.0 * x * y;
        }
        return v * mv;
    }
}

