/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import java.util.Map;
import java.util.Objects;

public class OrderSpec
implements InformationSetSerializable {
    public static final String TYPE = "type";
    public static final String REGULAR = "regular";
    public static final String SEASONAL = "seasonal";
    public int regular;
    public int seasonal;
    public Type type;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, TYPE), String.class);
        dic.put(InformationSet.item(prefix, REGULAR), Integer.class);
        dic.put(InformationSet.item(prefix, SEASONAL), Integer.class);
    }

    public OrderSpec(int regular, int seasonal, Type type) {
        this.regular = regular;
        this.seasonal = seasonal;
        this.type = type;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof OrderSpec && this.equals((OrderSpec)obj);
    }

    private boolean equals(OrderSpec other) {
        return this.regular == other.regular && this.seasonal == other.seasonal && this.type == other.type;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.regular;
        hash = 29 * hash + this.seasonal;
        hash = 29 * hash + Objects.hashCode((Object)this.type);
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        info.add(TYPE, this.type.name());
        if (verbose || this.regular != 0) {
            info.add(REGULAR, Integer.valueOf(this.regular));
        }
        if (verbose || this.seasonal != 0) {
            info.add(SEASONAL, Integer.valueOf(this.seasonal));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            String type_ = info.get(TYPE, String.class);
            Integer regular_ = info.get(REGULAR, Integer.class);
            Integer seasonal_ = info.get(SEASONAL, Integer.class);
            if (type_ == null) {
                return false;
            }
            this.type = Type.valueOf(type_);
            if (regular_ != null) {
                this.regular = regular_;
            }
            if (seasonal_ != null) {
                this.seasonal = seasonal_;
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public static enum Type {
        Fixed,
        Max;

    }
}

