/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.RationalBackFilter;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.AbstractOutlierVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class AdditiveOutlier
extends AbstractOutlierVariable {
    public static final String CODE = "AO";

    public AdditiveOutlier(Day pos) {
        super(pos);
    }

    @Override
    public void data(TsPeriod start, DataBlock data) {
        TsPeriod pstart = new TsPeriod(start.getFrequency(), this.position);
        int pos = pstart.minus(start);
        data.set(0.0);
        if (pos >= 0 && pos < data.getLength()) {
            data.set(pos, 1.0);
        }
    }

    @Override
    public OutlierType getOutlierType() {
        return OutlierType.AO;
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        return domain.search(this.position) >= 0;
    }

    @Override
    public IOutlierVariable.FilterRepresentation getFilterRepresentation(int freq) {
        return new IOutlierVariable.FilterRepresentation(new RationalBackFilter(BackFilter.ONE, BackFilter.ONE), 0.0);
    }

    @Override
    public String getCode() {
        return CODE;
    }
}

