/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.modelling.arima.ModelStatistics;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import java.util.Comparator;

public class ModelComparator
implements Comparator<PreprocessingModel> {
    private final Preference preference_;
    private double significance_ = 0.01;
    private double kbic_ = 0.03;
    private double kq_ = 1.1;
    private double kqs_ = 1.1;
    private int mout_ = 2;
    private int kout_ = 4;
    private double knz_ = 0.05;
    private double ksk_ = 1.25;
    private boolean acceptableQ_;
    private boolean acceptableOut_;
    private boolean acceptableSk_;
    private boolean acceptableQS_;
    private boolean acceptableStab_;

    public ModelComparator() {
        this.preference_ = Preference.BIC;
    }

    public ModelComparator(Preference pref) {
        this.preference_ = pref;
    }

    public double getSignificance() {
        return this.significance_;
    }

    public void setSignificance(double significance) {
        this.significance_ = significance;
    }

    @Override
    public int compare(PreprocessingModel m1, PreprocessingModel m2) {
        if (m1 == m2) {
            return 0;
        }
        ModelStatistics s1 = new ModelStatistics(m1);
        ModelStatistics s2 = new ModelStatistics(m2);
        if (this.preference_ == Preference.BIC && s2.bic < s1.bic || this.preference_ == Preference.Second) {
            if (!this.preferSecondModel(s2, s1)) {
                return 1;
            }
            return -1;
        }
        if (!this.preferSecondModel(s1, s2)) {
            return -1;
        }
        return 1;
    }

    private boolean preferSecondModel(ModelStatistics s1, ModelStatistics s2) {
        if (!this.checkAcceptable(s1, s2)) {
            return false;
        }
        return this.test1(s1, s2) || this.test2(s1, s2) || this.test3(s1, s2) || this.test4(s1, s2) || this.test5(s1, s2);
    }

    private boolean test1(ModelStatistics s1, ModelStatistics s2) {
        if (s1.ljungBoxPvalue >= this.significance_) {
            return false;
        }
        return !(s1.ljungBox <= s2.ljungBox * this.kq_);
    }

    private boolean test2(ModelStatistics s1, ModelStatistics s2) {
        if ((double)s1.outliers <= (double)s1.nz * this.knz_) {
            return false;
        }
        return s1.outliers > s2.outliers + this.mout_;
    }

    private boolean test3(ModelStatistics s1, ModelStatistics s2) {
        if (s1.seasLjungBoxPvalue >= this.significance_) {
            return false;
        }
        return !(s1.seasLjungBox <= s2.seasLjungBox * this.kqs_);
    }

    private boolean test4(ModelStatistics s1, ModelStatistics s2) {
        if (s1.skewnessPvalue >= this.significance_) {
            return false;
        }
        return !(s1.skewnessAbsvalue <= s2.skewnessAbsvalue * this.ksk_);
    }

    private boolean test5(ModelStatistics s1, ModelStatistics s2) {
        return s1.getStabilityScore() > s2.getStabilityScore();
    }

    private boolean checkAcceptable(ModelStatistics s1, ModelStatistics s2) {
        if (s2.bic - s1.bic >= Math.abs(s1.bic) * this.kbic_) {
            return false;
        }
        this.acceptableQ_ = s2.ljungBox < s1.ljungBox * this.kq_ || s2.ljungBoxPvalue > this.significance_;
        this.acceptableOut_ = s2.outliers < s1.outliers + 3 || (double)s2.outliers < this.knz_ * (double)s2.nz;
        this.acceptableSk_ = s2.skewnessAbsvalue < s1.skewnessAbsvalue * this.ksk_ || s2.skewnessPvalue > this.significance_;
        this.acceptableQS_ = s2.seasLjungBox < s1.seasLjungBox * this.kqs_ || s2.seasLjungBoxPvalue > this.significance_;
        this.acceptableStab_ = s2.stableMean;
        return this.acceptableQ_ && this.acceptableOut_ && this.acceptableSk_ && this.acceptableQS_;
    }

    public static enum Preference {
        BIC,
        First,
        Second;

    }
}

