% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMM_functions_cpp.R
\name{EMM1.cpp}
\alias{EMM1.cpp}
\title{Equation of mixed model for one kernel, GEMMA-based method (inplemented by Rcpp)}
\usage{
EMM1.cpp(y, X = NULL, ZETA, eigen.G = NULL, lam.len = 4,
  init.range = c(1e-04, 100), init.one = 0.5, conv.param = 1e-06,
  count.max = 15, bounds = c(1e-06, 1e+06), tol = NULL,
  REML = TRUE, silent = TRUE, plot.l = FALSE, SE = FALSE,
  return.Hinv = TRUE)
}
\arguments{
\item{y}{A \eqn{n \times 1} vector. A vector of phenotypic values should be used. NA is allowed.}

\item{X}{A \eqn{n \times p} matrix. You should assign mean vector (rep(1, n)) and covariates. NA is not allowed.}

\item{ZETA}{A list of variance (relationship) matrix (K; \eqn{m \times m}) and its design matrix (Z; \eqn{n \times m}) of random effects. You can use only one kernel matrix.
For example, ZETA = list(A = list(Z = Z, K = K))
Please set names of list "Z" and "K"!}

\item{eigen.G}{A list with
\describe{
\item{$values}{Eigen values}
\item{$vectors}{Eigen vectors}
}
The result of the eigen decompsition of \eqn{G = ZKZ'}. You can use "spectralG.cpp" function in RAINBOWR.
If this argument is NULL, the eigen decomposition will be performed in this function.
We recommend you assign the result of the eigen decomposition beforehand for time saving.}

\item{lam.len}{The number of initial values you set. If this number is large, the estimation will be more accurate,
but computational cost will be large. We recommend setting this value 3 <= lam.len <= 6.}

\item{init.range}{The range of the initial parameters. For example, if lam.len = 5 and init.range = c(1e-06, 1e02),
corresponding initial heritabilities will be calculated as seq(1e-06, 1 - 1e-02, length = 5),
and then initial lambdas will be set.}

\item{init.one}{The initial parameter if lam.len = 1.}

\item{conv.param}{The convergence parameter. If the diffrence of log-likelihood by updating the parameter "lambda"
is smaller than this conv.param, the iteration steps will be stopped.}

\item{count.max}{Sometimes algorithms won't converge for some initial parameters.
So if the iteration steps reache to this argument, you can stop the calculation even if algorithm doesn't converge.}

\item{bounds}{Lower and Upper bounds of the parameter 1 / lambda. If the updated parameter goes out of this range,
the parameter is reset to the value in this range.}

\item{tol}{The tolerance for detecting linear dependencies in the columns of G = ZKZ'.
Eigen vectors whose eigen values are less than "tol" argument will be omitted from results.
If tol is NULL, top 'n' eigen values will be effective.}

\item{REML}{You can choose which method you will use, "REML" or "ML".
If REML = TRUE, you will perform "REML", and if REML = FALSE, you will perform "ML".}

\item{silent}{If this argument is TRUE, warning messages will be shown when estimation is not accurate.}

\item{plot.l}{If you want to plot log-likelihood, please set plot.l = TRUE.
We don't recommend plot.l = TRUE when lam.len >= 2.}

\item{SE}{If TRUE, standard errors are calculated.}

\item{return.Hinv}{If TRUE, the function returns the inverse of \eqn{H = ZKZ' + \lambda I} where \eqn{\lambda = \sigma^2_e / \sigma^2_u}. This is useful for GWAS.}
}
\value{
\describe{
\item{$Vu}{Estimator for \eqn{\sigma^2_u}}
\item{$Ve}{Estimator for \eqn{\sigma^2_e}}
\item{$beta}{BLUE(\eqn{\beta})}
\item{$u}{BLUP(\eqn{u})}
\item{$LL}{Maximized log-likelihood (full or restricted, depending on method)}
\item{$beta.SE}{Standard error for \eqn{\beta} (If SE = TRUE)}
\item{$u.SE}{Standard error for \eqn{u^*-u} (If SE = TRUE)}
\item{$Hinv}{The inverse of \eqn{H = ZKZ' + \lambda I} (If return.Hinv = TRUE)}
\item{$Hinv2}{The inverse of \eqn{H2 = ZKZ'/\lambda + I} (If return.Hinv = TRUE)}
\item{$lambda}{Estimators for \eqn{\lambda = \sigma^2_e / \sigma^2_u}}
\item{$lambdas}{Lambdas for each initial values}
\item{$reest}{If parameter estimation may not be accurate, reest = 1, else reest = 0}
\item{$counts}{The number of iterations until convergence for each initial values}
}
}
\description{
This function solves the single-kernel linear mixed effects model by GEMMA
(genome wide efficient mixed model association; Zhou et al., 2012) approach.
}
\references{
Kang, H.M. et al. (2008) Efficient Control of Population Structure
 in Model Organism Association Mapping. Genetics. 178(3): 1709-1723.

Zhou, X. and Stephens, M. (2012) Genome-wide efficient mixed-model analysis
 for association studies. Nat Genet. 44(7): 821-824.
}
