% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_plots.R
\name{plot.drBootSpline}
\alias{plot.drBootSpline}
\title{Generic plot function for \code{gcBootSpline} objects.}
\usage{
\method{plot}{drBootSpline}(
  x,
  pch = 19,
  colData = 1,
  colSpline = "black",
  cex.point = 1,
  cex.lab = 1.5,
  cex.axis = 1.3,
  lwd = 2,
  plot = TRUE,
  export = FALSE,
  height = 7,
  width = 9,
  out.dir = NULL,
  combine = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{drBootSpline} object created with \code{\link{growth.drBootSpline}} or stored within a \code{grofit} or \code{drFit} object created with \code{\link{growth.workflow}} or \code{\link{growth.drFit}}, respectively.}

\item{pch}{(Numeric) Shape of the raw data symbols.}

\item{colData}{(Numeric or Character) Color used to plot the raw data.}

\item{colSpline}{(Numeric or Character) Color used to plot the splines.}

\item{cex.point}{(Numeric) Size of the raw data points.}

\item{cex.lab}{(Numeric) Font size of axis titles.}

\item{cex.axis}{(Numeric) Font size of axis annotations.}

\item{lwd}{(Numeric) Spline line width.}

\item{plot}{(Logical) Show the generated plot in the \code{Plots} pane (\code{TRUE}) or not (\code{FALSE}).}

\item{export}{(Logical) Export the generated plot as PDF and PNG files (\code{TRUE}) or not (\code{FALSE}).}

\item{height}{(Numeric) Height of the exported image in inches.}

\item{width}{(Numeric) Width of the exported image in inches.}

\item{out.dir}{(Character) Name or path to a folder in which the exported files are stored. If \code{NULL}, a "Plots" folder is created in the current working directory to store the files in.}

\item{combine}{(Logical) Indicate whether both dose-response curves and parameter plots shall be shown within the same window.}

\item{...}{Further arguments to refine the generated base R plot.}
}
\value{
A plot with the all dose-response spline fits from the bootstrapping operation.
}
\description{
Generic plot function for \code{gcBootSpline} objects.
}
\examples{
conc <- c(0, rev(unlist(lapply(1:18, function(x) 10*(2/3)^x))),10)
response <- c(1/(1+exp(-0.7*(4-conc[-20])))+stats::rnorm(19)/50, 0)

TestRun <- growth.drBootSpline(conc, response, drID = "test",
        control = growth.control(log.x.dr = TRUE, smooth.dr = 0.8, nboot.dr = 50))

print(summary(TestRun))
plot(TestRun, combine = TRUE)

}
