% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_tables.R
\name{table_group_growth_spline}
\alias{table_group_growth_spline}
\title{Generate a grouped results table for spline fits with average and standard deviations}
\usage{
table_group_growth_spline(gcTable, html = FALSE)
}
\arguments{
\item{gcTable}{An object of class \code{gcTable}}

\item{html}{(Logical) Should column headers contain html formatting?}
}
\value{
A data frame with grouped spline fit results. Empty cells indicate that no reliable fit could be determined.
}
\description{
Generate a grouped results table for spline fits with average and standard deviations
}
\examples{
# Create random growth data set
rnd.data <- rdm.data(d = 35, mu = 0.8, A = 5, label = "Test1")

# Run growth curve analysis workflow
res <- growth.workflow(time = rnd.data$time,
                       data = rnd.data$data,
                       fit.opt = "s",
                       ec50 = FALSE,
                       export.res = FALSE,
                       parallelize = FALSE,
                       suppress.messages = TRUE)

table_group_growth_spline(res$gcFit$gcTable)

# with HTML formatting
DT::datatable(table_group_growth_spline(res$gcFit$gcTable, html = TRUE),
              escape = FALSE) # Do not escape HTML entities

}
