% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_workflows.R
\name{growth.gcFit}
\alias{growth.gcFit}
\title{Perform a growth curve analysis on all samples in the provided dataset.}
\usage{
growth.gcFit(time, data, control = growth.control(), parallelize = TRUE, ...)
}
\arguments{
\item{time}{(optional) A matrix containing time values for each sample.}

\item{data}{Either... \enumerate{ \item a \code{grodata} object created with \code{\link{read_data}} or \code{\link{parse_data}},
\item a list containing a \code{'time'} matrix as well as \code{'growth'} and, if appropriate, a \code{'fluorescence'} dataframes,
or \item a dataframe containing growth values (if a \code{time} matrix is provided as separate argument).}}

\item{control}{A \code{grofit.control} object created with \code{\link{growth.control}}, defining relevant fitting options.}

\item{parallelize}{Run linear fits and bootstrapping operations in parallel using all but one available processor cores}

\item{...}{Further arguments passed to the shiny app.}
}
\value{
A \code{gcFit} object that contains all growth fitting results, compatible with
various plotting functions of the QurvE package.
\item{raw.time}{Raw time matrix passed to the function as \code{time}.}
\item{raw.data}{Raw growth dataframe passed to the function as \code{data}.}
\item{gcTable}{Table with growth parameters and related statistics for each growth curve evaluation performed by the function. This table, which is also returned by the generic \code{summary.gcFit} method applied to a \code{gcFit} object, is used as an input for \code{\link{growth.drFit}}.}
\item{gcFittedLinear}{List of all \code{gcFitLinear} objects, generated by the call of \code{\link{growth.gcFitLinear}}. Note: access to each object in the list via double brace: gcFittedLinear[[#n]].}
\item{gcFittedModels}{List of all \code{gcFitModel} objects, generated by the call of \code{\link{growth.gcFitModel}}. Note: access to each object in the list via double brace: gcFittedModels[[#n]].}
\item{gcFittedSplines}{List of all \code{gcFitSpline} objects, generated by the call of \code{\link{growth.gcFitSpline}}. Note: access to each object via double brace: gcFittedSplines[[#n]].}
\item{gcBootSplines}{List of all \code{gcBootSpline} objects, generated by the call of \code{\link{growth.gcBootSpline}}. Note: access to each object via double brace: gcFittedSplines[[#n]].}
\item{control}{Object of class \code{grofit.control} containing list of options passed to the function as \code{control}.}
}
\description{
\code{growth.gcFit} performs all computational growth fitting operations based on the
user input.
}
\examples{
# Create random growth data set
  rnd.data1 <- rdm.data(d = 35, mu = 0.8, A = 5, label = 'Test1')
  rnd.data2 <- rdm.data(d = 35, mu = 0.6, A = 4.5, label = 'Test2')

  rnd.data <- list()
  rnd.data[['time']] <- rbind(rnd.data1$time, rnd.data2$time)
  rnd.data[['data']] <- rbind(rnd.data1$data, rnd.data2$data)

# Run growth curve analysis workflow
  res <- growth.gcFit(time = rnd.data$time,
                      data = rnd.data$data,
                      parallelize = FALSE,
                      control = growth.control(suppress.messages = TRUE,
                                               fit.opt = 's'))



}
\references{
Matthias Kahm, Guido Hasenbrink, Hella Lichtenberg-Frate, Jost Ludwig, Maik Kschischo (2010). \emph{grofit: Fitting Biological Growth Curves with R}. Journal of Statistical Software, 33(7), 1-21. DOI: 10.18637/jss.v033.i07
}
\seealso{
Other workflows: 
\code{\link{flFit}()},
\code{\link{growth.workflow}()}

Other growth fitting functions: 
\code{\link{growth.drFit}()},
\code{\link{growth.gcBootSpline}()},
\code{\link{growth.gcFitLinear}()},
\code{\link{growth.gcFitModel}()},
\code{\link{growth.gcFitSpline}()},
\code{\link{growth.workflow}()}

Other dose-response analysis functions: 
\code{\link{flFit}()},
\code{\link{growth.drBootSpline}()},
\code{\link{growth.drFitSpline}()},
\code{\link{growth.workflow}()}
}
\concept{dose-response analysis functions}
\concept{growth fitting functions}
\concept{workflows}
