% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{tqdist_QuartetDistance}
\alias{tqdist_QuartetDistance}
\alias{tqdist_QuartetAgreement}
\alias{tqdist_PairsQuartetDistance}
\alias{tqdist_OneToManyQuartetAgreement}
\alias{tqdist_AllPairsQuartetDistance}
\alias{tqdist_AllPairsQuartetAgreement}
\alias{tqdist_TripletDistance}
\alias{tqdist_PairsTripletDistance}
\alias{tqdist_AllPairsTripletDistance}
\title{Triplet and quartet distances with tqDist}
\usage{
tqdist_QuartetDistance(file1, file2)

tqdist_QuartetAgreement(file1, file2)

tqdist_PairsQuartetDistance(file1, file2)

tqdist_OneToManyQuartetAgreement(file1, fileMany)

tqdist_AllPairsQuartetDistance(file)

tqdist_AllPairsQuartetAgreement(file)

tqdist_TripletDistance(file1, file2)

tqdist_PairsTripletDistance(file1, file2)

tqdist_AllPairsTripletDistance(file)
}
\arguments{
\item{file, file1, file2}{Paths to files containing a tree or trees in Newick format.}
}
\value{
The distance between the requested trees.
}
\description{
Functions to calculate triplet and quartet distances between pairs of trees.
Input is not checked for sanity.
}
\section{Functions}{
\itemize{
\item \code{tqdist_QuartetAgreement}: Agreement of each quartet

\item \code{tqdist_PairsQuartetDistance}: Distance between pairs

\item \code{tqdist_OneToManyQuartetAgreement}: Distance between pairs

\item \code{tqdist_AllPairsQuartetDistance}: Distance between all pairs

\item \code{tqdist_AllPairsQuartetAgreement}: Agreement between all pairs of trees

\item \code{tqdist_TripletDistance}: Triplet distance between two trees

\item \code{tqdist_PairsTripletDistance}: Triplet distance between pairs

\item \code{tqdist_AllPairsTripletDistance}: Triplet distance between all pairs
}}

\references{
\insertRef{Sand2014}{Quartet}
}
\author{
Martin R. Smith, after Andreas Sand
}
\keyword{internal}
