% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CellPhoneDB_analyse.R
\name{CellPhoneDB_analyse}
\alias{CellPhoneDB_analyse}
\title{Cellphone DB utility}
\usage{
CellPhoneDB_analyse(
  vgm.input,
  column,
  groups,
  organism,
  gene.id,
  analysis.method,
  project.name,
  iterations,
  threshold,
  result.precision,
  subsampling,
  subsampling.num.pc,
  subsampling.num.cells,
  subsampling.log,
  pvalue,
  debug.seed,
  threads,
  install.cellphonedb,
  pre.code,
  platypus.version
)
}
\arguments{
\item{vgm.input}{Output of the VDJ_GEX_matrix function}

\item{column}{Character vector. Mandatory. Column name of VDJ_GEX_matrix[[2]] where the groups to be tested for interactions are located}

\item{groups}{Strings vector. Mandatory. Vector with groups of the indicated column to be compared.}

\item{organism}{Character vector. Defaults to "human". If == "mouse" the function converts the gene's mouse names into the human ones.}

\item{gene.id}{Character vector. Defaults to "ensembl". Possible arguments: "ensembl" , "hgnc_symbol", "gene_name". Indicates the gene ID used by CellPhoneDB during the analysis. CellPhoneDB specific method argument.}

\item{analysis.method}{Character vector. Defaults to "statistical_analysis" Possible arguments: "statistical_analysis". CellPhoneDB is developing also "degs_analysis" method, which will be included among the possible arguments once released. Indicates the analysis method used by CellPhoneDB. CellPhoneDB specific method argument.}

\item{project.name}{Character vector. Defaults to NULL. If a name is given by the user, a subfolder with this name is created in the output folder. CellPhoneDB specific method argument.}

\item{iterations}{Numerical. Defaults to 1000. Number of iterations for the statistical analysis. CellPhoneDB specific method argument.}

\item{threshold}{Numerical. By defaults not specified. \% of cells expressing the specific ligand/receptor. Range: 0<= threshold <=1.}

\item{result.precision}{Numerical. Defaults to 3. Number of decimal digits in results. CellPhoneDB specific method argument.}

\item{subsampling}{Logical. Defaults to FALSE. If set to TRUE it enables subsampling. CellPhoneDB specific method argument.}

\item{subsampling.num.pc}{Numerical. Defaults to 100, if subsampling == TRUE. Number of PCs to use. CellPhoneDB specific method argument.}

\item{subsampling.num.cells}{Numerical. Defaults to 1/3 of cells, if subsampling == TRUE. Number of cells to subsample. CellPhoneDB specific method argument.}

\item{subsampling.log}{Logical. No default, mandatory when subsampling. Enables subsampling log1p for non log-transformed data inputs. CellPhoneDB specific method argument.}

\item{pvalue}{Numerical. Defaults to 0.05. P-value threshold. CellPhoneDB specific statistical method argument.}

\item{debug.seed}{Numerical. Deafults to -1. Debug random seed. To disable it use a value >=0. CellPhoneDB specific statistical method argument}

\item{threads}{Numerical. Defaults to -1. Number of threads to use (needs to be >=1). CellPhoneDB specific statistical method argument.}

\item{install.cellphonedb}{Logical. Defaults to TRUE. Installs the CellPhoneDB Python package if set ==TRUE.}

\item{pre.code}{Character string. One command line or multiple command lines separated by " && " of code to execute in the console before cellphonedb is called. In case Cellphonedb is installed within a Conda enviroment (highly recommended), set this to "conda activate MyEnviroment", "activate MyEnviroment" or "conda init cmd.exe && activate MyEnviroment" depending on your Conda installation.}

\item{platypus.version}{This function works with "v3" only, there is no need to set this parameter}
}
\value{
VDJ_GEX_matrix object with additional list item (VDJ_GEX_matrix[[10]]), containing results and plots of CellPhoneDB analysis. Saves in the directory the input files, results and plots of CellPhoneDB analysis.
}
\description{
Function to set up the data so that it can be read and processed by CellPhoneDB, which saves the results of the analysis in a directory "out" and adds them in a new vgm (output of VDJ_GEX_matrix function) list item (CellPhoneDB). Needs Python to be installed in the computer. Running time can take some minutes. Depending on the state of the connection to ensembl and whether this is down, the function might not work if it needs to convert the genes identity. In these cases, try at some other moment and the connection should hopefully be back.
!!! In case the python call does is not executed, please refer to the parameter "pre.code" !!!
}
\examples{
\dontrun{
vgm_cellphonedb<-CellPhoneDB_analyse(vgm.input=vgm_m,
organism="mouse", groups=c(3,6,9),
gene.id="ensembl",
analysis.method= "statistical_analysis",
install.cellphonedb = FALSE,
subsampling= TRUE,
subsampling.num.pc=100,
subsampling.num.cells=70,
subsampling.log=TRUE,
project.name = "test")
}
}
