% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntibodyForests_node_transitions.R
\name{AntibodyForests_node_transitions}
\alias{AntibodyForests_node_transitions}
\title{Calculates the node transitions frequencies for a given feature and an AntibodyForests object}
\usage{
AntibodyForests_node_transitions(
  trees,
  features,
  combined,
  graph.type,
  permutation.test,
  exclude.germline,
  exclude.intermediates,
  n.permutations,
  plot.results,
  parallel
)
}
\arguments{
\item{trees}{nested list of AntibodyForests objects or single object, as obtained from the AntibodyForests function.}

\item{features}{vector of strings - features for the node transition counting. Each node will be assigned the dominant feature if its constituent cells have different feature values (e.g., for features = c('seurat_clusters')). These features need to be first added as vertex attributes when creating the AntibodyForests networks, specified in the node.features parameter of AntibodyForests.}

\item{combined}{boolean - if T, will assign a new feature by combining the feature values as specified in the features parameter (e.g., if node 1 has VDJ_cgene = 'IGHM' and seurat_clusters = 1, will create a new feature = 'IGHM 1' for that node, for joint node transitions).}

\item{graph.type}{string - the graph type available in the AntibodyForests object which will be used as the function input.
Currently supported network/analysis types: 'tree' (for the minimum spanning trees or sequence similarity networks obtained from the main AntibodyForests function), 'heterogeneous' for the bipartite graphs obtained via AntibodyForests_heterogeneous, 'dynamic' for the dynamic networks obtained from AntibodyForests_dynamics.}

\item{permutation.test}{boolean - if T, will perform a permutation statistical test on the node feature transition values.}

\item{exclude.germline}{boolean - if T, will exclude the germline from the node feature transitions counting.}

\item{exclude.intermediates}{boolean - if T, will exclude the intermediate nodes expanded using AntibodyForests_expand_intermediates() from the node transitions counting.}

\item{n.permutations}{integer - number of node feature permutations for the permutation test.}

\item{plot.results}{boolean - if T, will display the node transitions counts as bar plots, per feature specified in the features parameter.}

\item{parallel}{boolean - whether to execute the main subroutine in parallel or not. Requires the 'parallel' R package to be installed.}
}
\value{
nested list of AntibodyForests objects for each clonotype and each sample or single object, with an additional node_transitions slot of transition/edge counts.
}
\description{
Node transitions represent the number of (un)directed edges between two feature values of a given feature type in a single sequence similarity network or minimum spanning trees (e.g., between VDJ_cgene = 'IGHA' and VDJ_cgene = 'IGHM'). The resulting AntibodyForests objects will contain a new slot - node_transitions. Will also output bar plots of the transition frequencies.
}
\examples{
\dontrun{
AntibodyForests_node_transitions(trees,
graph.type = 'tree', features = 'VDJ_cgene',
plot.results = T)
}
}
