% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spatial_density_plot.R
\name{Spatial_density_plot}
\alias{Spatial_density_plot}
\title{Plotting the contour density of selected cells or of all cells.}
\usage{
Spatial_density_plot(
  sample_names,
  bcs_merge,
  images_tibble,
  vgm_VDJ,
  title,
  size
)
}
\arguments{
\item{sample_names}{Character vector containing the name of the sample.}

\item{bcs_merge}{Data frame containing imagerow, imagecol and barcode of the cells belonging to the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 10.}

\item{images_tibble}{Tbl-df containing the sample name, grob, height and width of the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 5.}

\item{vgm_VDJ}{Data frame containing all the data on the cell. It must contain the column clonotype_id which describes the number of the clonotype to which the cell belongs. This data frame can be obtained by the assignment functions (VDJ_assignment_random_based, VDJ_assignment_density_based and VDJ_assignment_germline_based).}

\item{title}{Character vector to name the plot.}

\item{size}{Number, to define the size of the text, default = 15.}
}
\value{
Returns a plot of cell contour density on the spatial image.
}
\description{
Plotting the contour density of selected cells or of all cells.
}
\examples{
\dontrun{
#Assignment density-based
density_BCR_assignment<-Spatial_VDJ_assignment(GEX_matrix = GEX_matrix,
vgm = vgm_with_simulated_VDJ,
vgm_VDJ = vgm_with_simulated_VDJ$VDJ, celltype = "B",
simulated_VDJ = simulated_B_cells_VDJ,
method = "density")
vgm_with_simulated_VDJ$VDJ<-density_BCR_assignment

top_1_VDJ_BCR_density_data<-Spatial_selection_expanded_clonotypes(
nb_clonotype = 1, vgm_VDJ = vgm_with_simulated_VDJ$VDJ)

p_spatial_BCR_density_clonotype_density<-Spatial_density_plot(
vgm_VDJ = top_1_VDJ_BCR_density_data,
images_tibble = scaling_parameters[[5]],
bcs_merge = scaling_parameters[[10]],sample_names = sample_names,
title = "B cell density assignment")
p_spatial_BCR_density_clonotype_density
}
}
