% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEX_visualize_clones.R
\name{GEX_visualize_clones}
\alias{GEX_visualize_clones}
\title{Platypus V2 GEX and VDJ integration for visualizing clone clustering}
\usage{
GEX_visualize_clones(
  GEX.list,
  VDJ.GEX.integrate.list,
  highlight.type,
  highlight.number,
  reduction
)
}
\arguments{
\item{GEX.list}{list of Seurat objects, output of the automate_GEX function.}

\item{VDJ.GEX.integrate.list}{Output of the VDJ_GEX_integrate function.}

\item{highlight.type}{(Optional) either "None" if representation highlighted by cluster, "clonotype" if want to highlight most expanded clonotypes, or "sample" if several samples are within the same Seurat object. Default is None.}

\item{highlight.number}{(Optional) an integer or list of integers representing the number of most expanded clonotypes or samples one wants to select eg 4 to highlight the 4th most expanded clonotype or 2:5 to highlight the top 2 to top 5 most expanded clonotype. Only compatible with highlight.type "clonotype" or "sample", will be ignored if type is "None". Default is 1.}

\item{reduction}{(Optional) Reduction to plot, either "tsne", "umap", or "harmony". Default is "tsne".}
}
\value{
concatenated ggplot2 plot with selected clonotypes highlighted (if None, the coloring is according to the clustering).
}
\description{
!Only for platypus version v2. For platypus v3 refer to: VDJ_GEX_overlay_clones() Visualize selected clonotypes on the tSNE or UMAP projection.
}
\examples{
\dontrun{
GEX_visualize_clones(GEX.list=automate_GEX.output,
 VDJ.per.clone=VDJ_per_clone.output,
 highlight.type="clonotype",
 highlight.number=1:4,
 reduction="umap")
}
}
