% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntibodyForests_kernels.R
\name{AntibodyForests_kernels}
\alias{AntibodyForests_kernels}
\title{Graph kernel methods for graph structure/topology comparisons}
\usage{
AntibodyForests_kernels(
  trees,
  graph.type,
  kernel.method,
  additional.param,
  max.networks
)
}
\arguments{
\item{trees}{(nested) list of AntibodyForests objects, as obtained from the AntibodyForests function, to be compared.}

\item{graph.type}{string - 'tree' will use the usual output of the AntibodyForests function (tree graphs), 'heterogeneous' will use the output of the AntibodyForests_heterogeneous function (bipartite networks for both cells and sequences).}

\item{kernel.method}{string - kernel method to be used, as implemented in the 'graphkernels' R package. 'weisfeiler_lehman' for the Weisfeiler-Lehman kernel, 'graphlet, and 'random_walk'.}

\item{additional.param}{integer - additional kernel options/parameters (e.g., kernel iterations for the Weisfeiler-Lehman kernel).}

\item{max.networks}{integer - maximum number of networks to be compared (will pick the networks with the most number of cells first).}
}
\value{
Heatmap of the graph kernel values.
}
\description{
Performs graph structural comparisons using graph kernel-based method. Currently available kernel methods include: the Weisfeiler-Lehman kernel, the graphlet kernel, and the random walk kernel.
}
\examples{
\dontrun{
AntibodyForests_kernels(trees, graph.type = 'tree',
kernel.method = 'weisfeiler_lehman',
additional.params = 10, max.networks = 50)
}
}
