% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntibodyForests_join_trees.R
\name{AntibodyForests_join_trees}
\alias{AntibodyForests_join_trees}
\title{Joins a list of trees/networks as AntibodyForests objects into a single AntibodyForests object}
\usage{
AntibodyForests_join_trees(tree.list, join.per, join.method)
}
\arguments{
\item{tree.list}{(nested) list of AntibodyForests objects, as obtained from the AntibodyForests function.}

\item{join.per}{string - 'sample' joins the objects per sample if the input is a nested list of AntibodyForests objects, resulting in a single joined graph per sample, 'global' joins all graphs in the nested list into a single object.}

\item{join.method}{string - networks, especially minimum spanning trees, can be joined into a single connected graph if join.method = 'single.germline' (will pick a single germline from all available germlines and will recalculate the string distance) or 'multiple.germlines.joined' (will add inter-germline edges).
Will create a single object with disconnected subgraph if join.method = 'multiple.germlines'.}
}
\value{
single AntibodyForests object consisting of the joined graphs/trees. Resulting graph can be either a single connected component (if join.method = 'single.germline' or 'multiple.germlines.joined') or multiple disconnected subgraphs (join.method = 'multiple.germlines').
}
\description{
Joins a list of trees/networks as AntibodyForests into a single AntibodyForests object. The resulting network will include all joined networks as separate components. Useful for faster downstream analyses (e.g., node metrics via AntibodyForests_metrics on this object instead on each separate object, plotting multiple trees in the same plot, etc.,)
}
\examples{
\dontrun{
AntibodyForests_join_trees(tree.list, join.per = 'sample', join.method = 'multiple.germlines')
}
}
