% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateEM.R
\name{merge_alpha_grids}
\alias{merge_alpha_grids}
\title{Merge PhyloEM fits on various grids of alpha values}
\usage{
merge_alpha_grids(...)
}
\arguments{
\item{...}{objects of class \code{\link{PhyloEM}} fitted on the same dataset 
with the same parameters, but different grids of alpha values.}
}
\value{
An object of class \code{\link{PhyloEM}}, result of the merge.
}
\description{
\code{merge_alpha_grids} takes several fits from \code{\link{PhyloEM}}, and
merge them so as to take into account all alpha values.
This can be used to break down computations into smaller chunks to be run independently.
}
\examples{
\dontrun{
## Load Data
data(monkeys)
## First fit with coarse grid
res1 <- PhyloEM(Y_data = monkeys$dat,
                phylo = monkeys$phy,
                process = "scOU",
                random.root = TRUE,
                stationary.root = TRUE,
                K_max = 10,
                alpha = c(0.2, 0.3),
                parallel_alpha = TRUE,
                Ncores = 2)
## Second fit with finer grid
res2 <- PhyloEM(Y_data = monkeys$dat,
                phylo = monkeys$phy,
                process = "scOU",
                random.root = TRUE,
                stationary.root = TRUE,
                K_max = 10,
                alpha = c(0.22, 0.24),
                parallel_alpha = TRUE,
                Ncores = 2)
## Thrid fit with redundancies
res3 <- PhyloEM(Y_data = monkeys$dat,
                phylo = monkeys$phy,
                process = "scOU",
                random.root = TRUE,
                stationary.root = TRUE,
                K_max = 10,
                alpha = c(0.26, 0.3),
                parallel_alpha = TRUE,
                Ncores = 2)

## Merge the three
res_merge <- merge_alpha_grids(res1, res2, res3)
## Plot the selected result
plot(res_merge)
## Plot the model selection criterion
plot_criterion(res_merge)
}

}
