% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_functions.R
\name{find_grid_alpha}
\alias{find_grid_alpha}
\title{Find a reasonable grid for alpha}
\usage{
find_grid_alpha(
  phy,
  alpha = NULL,
  nbr_alpha = 10,
  factor_up_alpha = 2,
  factor_down_alpha = 3,
  quantile_low_distance = 1e-04,
  log_transform = TRUE,
  allow_negative = FALSE,
  ...
)
}
\arguments{
\item{phy}{phylogenetic tree of class "\code{phylo}"}

\item{alpha}{fixed vector of alpha values if already known. Default to NULL.}

\item{nbr_alpha}{the number of elements in the grid}

\item{factor_up_alpha}{factor for up scalability}

\item{factor_down_alpha}{factor for down scalability}

\item{quantile_low_distance}{quantile for min distance}

\item{log_transform}{whether to take a log scale for the spacing of alpha
values. Default to TRUE.}

\item{allow_negative}{whether to allow negative values for alpha (Early Burst).
See documentation of \code{\link{PhyloEM}} for more details. Default to FALSE.}

\item{...}{not used.}
}
\value{
A grid of alpha values
}
\description{
Grid so that 
2*ln(2)*quantile(d_ij)/factor_up_alpha < t_{1/2} < factor_down_alpha * ln(2) * h_tree
Ensures that for alpha_min, it is almost a BM, and for alpha_max,
almost all the tips are decorrelated.
}
\details{
If \code{quantile_low_distance=0}, then \code{quantile(d_ij)=min(d_ij)}, and, for any
two tips i,j, the correlation between i and j is bounded by exp(-factor_up_alpha/2).
Those values of alpha will be used for the re-scaling of the tree, which has an 
exponential term in exp(2*alpha*h). The function makes sure that this number is
below the maximal float allowed (equals to \code{.Machine$double.xmax}).
}
\seealso{
\code{\link{transform_branch_length}}, \code{\link{.Machine}}
}
