% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsimonyNumber.R
\name{check_parsimony}
\alias{check_parsimony}
\title{Check Parsimony, assuming no homoplasy}
\usage{
check_parsimony(tree, edges, ...)
}
\arguments{
\item{tree}{phylogenetic tree}

\item{edges}{a vector of edges of the tree, where the shifts are}

\item{...}{possibly, a list giving the descendant tips of each edge}
}
\value{
boolean : TRUE if the allocation is parsimonious.
}
\description{
\code{check_parsimony} take a vector of shifts edges, and check whether the
number of groups of the tips induced by this allocation is exactly the number of
shifts plus one. This is equivalent to parsimony when there is no homoplasy (i.e. no 
convergent regimes).
}
\details{
This function computes explicitly the clustering of the tips, using 
function \code{\link{clusters_from_shifts}}.
By default, this function uses \code{\link{enumerate_tips_under_edges}} to compute 
the list of tips under each edge, but a list can be provided (to avoid extra
computation, if many tests on the same tree are done).
}
