% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_map.R
\name{monitor_map}
\alias{monitor_map}
\title{Static map of monitoring stations}
\usage{
monitor_map(ws_monitor, slice = get("max"), breaks = AQI$breaks_24,
  colors = AQI$colors, pch = par("pch"), cex = par("cex"),
  stateCol = "grey60", stateLwd = 2, countyCol = "grey70",
  countyLwd = 1, add = FALSE, ...)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{slice}{either a time index or a function used to collapse the time axis}

\item{breaks}{set of breaks used to assign colors}

\item{colors}{set of colors must be one less than the number of breaks}

\item{pch}{Plot symbols used to draw points on the map.}

\item{cex}{the amount that the points will be magnified on the map}

\item{stateCol}{color for state outlines on the map}

\item{stateLwd}{width for state outlines}

\item{countyCol}{color for county outline on the map}

\item{countyLwd}{width for county outlines}

\item{add}{logical specifying whether to add to the current plot}

\item{...}{additional arguments passed to \code{maps::map()} such as
\code{'projection'} or \code{'parameters'}}
}
\description{
Creates a map of monitoring stations in a given ws_monitor object. Individual
monitor timeseries are reduced to a single value by applying the function
passed in as \code{slice} to the entire timeseries of each monitor with
\code{na.rm=TRUE}. These values are then plotted over a map of the United
States. Any additional arguments specified in '...' are passed on to the
\code{points()} function.

If \code{slice} is an integer, it will be used as an index to pull out a
single timestep.

If \code{slice} is a function (not a function name) it will be used with
argument \code{na.rm=TRUE} to collapse the time dimension. Thus, any user
defined functions passed in as \code{slice} must accept \code{na.rm} as a
parameter.
}
\details{
Using a single number for the \code{breaks} argument will result in the use
of quantiles to determine a set of breaks appropriate for the number of
colors.
}
\examples{
\dontrun{
N_M <- monitor_subset(Northwest_Megafires, tlim = c(20150821,20150828))
monitor_map(N_M, cex = 2)
addAQILegend()
}
}
\keyword{ws_monitor}
