% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_MS2Oversampling}
\alias{plot_MS2Oversampling}
\title{Plot bargraph of oversampled 3D-peaks.}
\usage{
plot_MS2Oversampling(data)
}
\arguments{
\item{data}{A data.frame with columns 'fc.raw.file', 'n', 'fraction'}
}
\value{
GGplot object
}
\description{
Per Raw file, at most three n's must be given, i.e.
the fraction of 3D-peaks for n=1, n=2 and n=3(or more).
The fractions must sum to 1 (=100%).
}
\examples{
  data = data.frame(fc.raw.file = rep(letters[1:3], each=3),
                    n = 1:3,
                    fraction = c(0.8, 0.1, 0.1, 0.6, 0.3, 0.1, 0.7, 0.25, 0.05))
  plot_MS2Oversampling(data)

}
