% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_MQalign.R
\name{findAlignReference}
\alias{findAlignReference}
\title{Return list of raw file names which were reported by MaxQuant as reference point for alignment.}
\usage{
findAlignReference(data)
}
\arguments{
\item{data}{The data.frame with columns 'retention.time.calibration' and 'raw.file'}
}
\value{
List of reference raw files (usually just one)
}
\description{
There is only one reference point which has '0' in 'retention.time.calibration' column in evidence.txt 
as corrected RT. This is true for most MaxQuant versions
and also true for fractions. However, some evidence.txt files show 0.03 as an averaged minimum per Raw file.
We use the raw.file with the smallest average as reference.
}
\details{
Note that MaxQuant uses a guide tree to align the Raw files, so the order of files does not influence the 
alignment. But the first file will always be used as reference point when reporting delta-RTs. And this file is also
used by PTXQC as reference file vs all other files to find the real calibration function (see alignmentCheck()).

This function might return multiple raw file names (if MQ decides to change its mind at some point in the future).
In this case the result should be treated with caution or (better) regarded as failure.
}
