% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist_SA.R
\docType{data}
\name{hist_SA}
\alias{hist_SA}
\title{Single-agent example}
\format{
A data frame with 5 rows and 4 variables:
\describe{
  \item{group_id}{study}
  \item{drug_A}{dose}
  \item{num_patients}{number of patients}
  \item{num_toxicities}{number of events}
}
}
\usage{
hist_SA
}
\description{
Example data from the application in Neuenschwander, et. al. 2008, from
an "open-label, multicenter, non-comparative, dose-escalation cancer trial to
characterize the safety, tolerability, and pharmacokinetic profile of a drug
and to determine its MTD."
}
\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 100x more warmup & iter in practice
.user_mc_options <- options(OncoBayes2.MC.warmup=10, OncoBayes2.MC.iter=20, OncoBayes2.MC.chains=1)

## Example from Neuenschwander, B., et al. (2009). Stats in Medicine

num_comp <- 1 # one investigational drug
num_inter <- 0 # no drug-drug interactions need to be modeled
num_groups <- nlevels(hist_SA$group_id) # no stratification needed
num_strata <- 1 # no stratification needed


dref <- 50

## Since there is no prior information the hierarchical model
## is not used in this example by setting tau to (almost) 0.
blrmfit <- blrm_exnex(
  cbind(num_toxicities, num_patients - num_toxicities) ~
    1 + log(drug_A / dref) |
    0 |
    group_id,
  data = hist_SA,
  prior_EX_mu_mean_comp = matrix(
    c(logit(1/2), # mean of intercept on logit scale
      log(1)),    # mean of log-slope on logit scale
    nrow = num_comp,
    ncol = 2
  ),
  prior_EX_mu_sd_comp = matrix(
    c(2,  # sd of intercept
      1), # sd of log-slope
    nrow = num_comp,
    ncol = 2
  ),
  ## Here we take tau as known and as zero.
  ## This disables the hierarchical prior which is
  ## not required in this example as we analyze a
  ## single trial.
  prior_EX_tau_mean_comp = matrix(
    c(0, 0),
    nrow = num_comp,
    ncol = 2
  ),
  prior_EX_tau_sd_comp = matrix(
    c(1, 1),
    nrow = num_comp,
    ncol = 2
  ),
  prior_EX_prob_comp = matrix(1, nrow = num_comp, ncol = 1),
  prior_tau_dist = 0,
  prior_PD = FALSE
)
## Recover user set sampling defaults
options(.user_mc_options)

}
\references{
Neuenschwander, B., Branson, M., & Gsponer, T. (2008). 
 Critical aspects of the Bayesian approach to phase I cancer trials. 
 \emph{Statistics in medicine}, 27(13), 2420-2439.
}
\keyword{datasets}
