#' @title Signal Component Analysis for Optically Stimulated Luminescence
#'
#' @description Function library for the identification and separation of exponentially
#' decaying signal components in continuous-wave optically stimulated luminescence (CW-OSL) measurements.
#' A special emphasis is laid on luminescence dating with quartz, which is known for
#' systematic errors due to CW-OSL signal components with unequal physical behaviour.
#' Also, this package enables an easy to use signal decomposition of
#' CW-OSL data sets imported and analysed with the R package 'Luminescence'.
#' This includes the optional automatic creation of HTML reports.
#'
#' @name OSLdecomposition-package
#' @aliases OSLdecomposition
#' @keywords package
#' @docType package
#'
#' @details
#'
#' **Project website**
#'
#' - [https://luminescence.de]()
#'
#' **Source code repository**
#'
#' - [https://github.com/DirkMittelstrass/OSLdecomposition]()
#'
#' **Bug reporting**
#'
#' - [https://github.com/DirkMittelstrass/OSLdecomposition/issues]()
#'
#' **This package is part of the RLum.Network**
#'
#' - [https://r-luminescence.org]()
#'
#' **Package maintainer**
#'
#' Dirk Mittelstraß, Independent researcher, Dresden (Germany),\cr
#' \email{dirk.mittelstrass@@luminescence.de}
#'
#' **Citation**
#'
#' Mittelstraß, D., Schmidt, C., Beyer, J., Heitmann, J. and Straessner, A.:
#' R package OSLdecomposition: Automated identification and separation of quartz CW-OSL signal components, *in preparation*.
#'
#' **Funding**
#' Dirk Mittelstraß created this package as part of his master thesis and further enhanced and
#' published it as private endeavour. He did not receive any specific grant from funding agencies
#' in the public, commercial or not-for-profit sectors.
#'
#' @md
NULL
